#pragma once

#include "VBufferT.h"
//-----------------------------------------------------------------------
//block_t define
//-----------------------------------------------------------------------

/** The content doesn't follow the last block, or is probably broken */
#define BLOCK_FLAG_DISCONTINUITY 0x0001
/** Intra frame */
#define BLOCK_FLAG_TYPE_I        0x0002
/** Inter frame with backward reference only */
#define BLOCK_FLAG_TYPE_P        0x0004
/** Inter frame with backward and forward reference */
#define BLOCK_FLAG_TYPE_B        0x0008
/** For inter frame when you don't know the real type */
#define BLOCK_FLAG_TYPE_PB       0x0010
/** Warm that this block is a header one */
#define BLOCK_FLAG_HEADER        0x0020
/** This is the last block of the frame */
#define BLOCK_FLAG_END_OF_FRAME  0x0040
/** This is not a key frame for bitrate shaping */
#define BLOCK_FLAG_NO_KEYFRAME   0x0080
/** This block contains a clock reference */
#define BLOCK_FLAG_CLOCK         0x0200
/** This block is scrambled */
#define BLOCK_FLAG_SCRAMBLED     0x0400
/** This block has to be decoded but not be displayed */
#define BLOCK_FLAG_PREROLL       0x0800
/** This block is corrupted and/or there is data loss  */
#define BLOCK_FLAG_CORRUPTED     0x1000

#define BLOCK_FLAG_PRIVATE_MASK  0xffff0000
#define BLOCK_FLAG_PRIVATE_SHIFT 16

struct block_t : public Buffer
{
	block_t()
	{
		p_next = NULL;
		p_prev = NULL;

		i_flags = 0;

		i_pts = 0;
		i_dts = 0;
		i_length = 0;

		i_samples = 0;
		i_rate = 0;
	};

	virtual	~block_t()
	{

	};
	
	block_t     *p_next;
	block_t     *p_prev;

	uint32_t    i_flags;

	int64_t     i_pts;
	int64_t     i_dts;
	int64_t     i_length;

	int         i_samples; /* Used for audio */
	int         i_rate;
};

static inline void block_ChainAppend( block_t **pp_list, block_t *p_block )
{
	if( *pp_list == NULL )
	{
		*pp_list = p_block;
	}
	else
	{
		block_t *p = *pp_list;

		while( p->p_next ) p = p->p_next;
		p->p_next = p_block;
	}
}

class block_fifo_t : public VBufferT
{
public:

	virtual ~block_fifo_t()
	{

	};

	virtual Buffer* GetFullBufferShadow()
	{
		Buffer* pFullBuffer;

		ATLock lock(this);

		if( m_FullBuffer.empty())
			return NULL;

		pFullBuffer = m_FullBuffer.front();

		return pFullBuffer;
	};
};
