#pragma once

#include "block.h"

typedef struct 
{
	int     i_depth;
	block_t *p_first;
	block_t **pp_last;
} buffer_chain_t;

static inline void BufferChainInit  ( buffer_chain_t *c )
{
	c->i_depth = 0;
	c->p_first = NULL;
	c->pp_last = &c->p_first;
}

static inline void BufferChainAppend( buffer_chain_t *c, block_t *b )
{
	*c->pp_last = b;
	c->i_depth++;

	while( b->p_next )
	{
		b = b->p_next;
		c->i_depth++;
	}
	c->pp_last = &b->p_next;
}

static inline block_t *BufferChainGet( buffer_chain_t *c )
{
	block_t *b = c->p_first;

	if( b )
	{
		c->i_depth--;
		c->p_first = b->p_next;

		if( c->p_first == NULL )
		{
			c->pp_last = &c->p_first;
		}

		b->p_next = NULL;
	}
	return b;
}

static inline block_t *BufferChainPeek( buffer_chain_t *c )
{
	block_t *b = c->p_first;

	return b;
}

static inline void BufferChainClean( buffer_chain_t *c )
{
	block_t *b;

	while( ( b = BufferChainGet( c ) ) )
	{
		delete b;//block_Release( b );
	}
	BufferChainInit( c );
}
