#pragma once

typedef unsigned char       uint8_t;
typedef signed char         int8_t;
typedef unsigned short      uint16_t;
typedef signed short        int16_t;
typedef unsigned int        uint32_t;
typedef signed int          int32_t;

typedef unsigned __int64    uint64_t;
typedef signed __int64      int64_t;

typedef uint8_t             byte_t;

typedef int bool_t;
typedef int64_t mtime_t;

#define off_t __int64;
#define ssize_t int;

#define INT64_C(val) val##LL
#define UINT64C(var) val##ULL

typedef uint32_t fourcc_t;

#ifdef WORDS_BIGENDIAN
#   define FOURCC( a, b, c, d ) \
	( ((uint32_t)d) | ( ((uint32_t)c) << 8 ) \
	| ( ((uint32_t)b) << 16 ) | ( ((uint32_t)a) << 24 ) )
#   define TWOCC( a, b ) \
	( (uint16_t)(b) | ( (uint16_t)(a) << 8 ) )

#else
#   define FOURCC( a, b, c, d ) \
	( ((uint32_t)a) | ( ((uint32_t)b) << 8 ) \
	| ( ((uint32_t)c) << 16 ) | ( ((uint32_t)d) << 24 ) )
#   define TWOCC( a, b ) \
	( (uint16_t)(a) | ( (uint16_t)(b) << 8 ) )

#endif

#define __MIN(a, b) ( ((a) < (b)) ? (a) : (b) )

/*****************************************************************************
* Plug-in stuff
*****************************************************************************/
#if !defined (__PLUGIN__)
#   ifdef __cplusplus
#      define EXPORT( type, name, args ) extern "C" type name args
#   else
#      define EXPORT( type, name, args ) type name args
#   endif
#endif

#ifndef _DIV_T_DEFINED
typedef struct {
	long long quot; /* Quotient. */
	long long rem;  /* Remainder. */
} lldiv_t;

static inline lldiv_t lldiv (long long numer, long long denom)
{
	lldiv_t d;
	d.quot = numer / denom;
	d.rem  = numer % denom;
	return d;
}
#define _DIV_T_DEFINED
#endif

#pragma warning(disable : 4996)
#define snprintf _snprintf

/* Multiplier value for aspect ratio calculation (2^7 * 3^3 * 5^3) */
#define VOUT_ASPECT_FACTOR              432000
