#pragma once

typedef struct h264_pps_t {
	int i_pic_order_present_flag;
} h264_pps_t;

#define PPS_MAX (256)

static BOOL h264_decode_picture_parameter_set(h264_pps_t* p_pps, uint8_t* p_data,  int n_data_size)
{
	bs_t s;
	int i_pps_id;
	int i_sps_id;

	bs_init( &s, p_data, n_data_size);
	i_pps_id = bs_read_ue( &s ); // pps id
	i_sps_id = bs_read_ue( &s ); // sps id
	if( i_pps_id >= PPS_MAX || i_sps_id >= SPS_MAX )
	{
		printf( "invalid PPS (pps_id=%d sps_id=%d)\n", i_pps_id, i_sps_id );
		return FALSE;
	}
	bs_skip( &s, 1 ); // entropy coding mode flag
	p_pps->i_pic_order_present_flag = bs_read( &s, 1 );

	return TRUE;
}