//////////////////////////////////////////////////////////////////////////
// ϲ֮ɵĿ
// 70565912@qq.com
//////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "TsMux.h"
#include "TsMuxDef.h"

static uint32_t GetDescriptorLength24b( int i_length )
{
	uint32_t i_l1, i_l2, i_l3;

	i_l1 = i_length&0x7f;
	i_l2 = ( i_length >> 7 )&0x7f;
	i_l3 = ( i_length >> 14 )&0x7f;

	return( 0x808000 | ( i_l3 << 16 ) | ( i_l2 << 8 ) | i_l1 );
}

static int intcompare( const void *pa, const void *pb )
{
	if ( *(int *)pa  < *(int *)pb )
		return -1;
	else if ( *(int *)pa > *(int *)pb )
		return 1;
	else
		return 0;
};
static int pmtcompare( const void *pa, const void *pb )
{
	if ( ((pmt_map_t *)pa)->i_pid  < ((pmt_map_t *)pb)->i_pid )
		return -1;
	else if ( ((pmt_map_t *)pa)->i_pid  > ((pmt_map_t *)pb)->i_pid )
		return 1;
	else
		return 0;
}

static int AllocatePID( mux_sys_t *p_sys, int i_cat )
{
	int i_pid;
	if ( i_cat == VIDEO_ES && p_sys->i_pid_video )
	{
		i_pid = p_sys->i_pid_video;
		p_sys->i_pid_video = 0;
	}
	else if ( i_cat == AUDIO_ES && p_sys->i_pid_audio )
	{
		i_pid = p_sys->i_pid_audio;
		p_sys->i_pid_audio = 0;
	}
	else if ( i_cat == SPU_ES && p_sys->i_pid_spu )
	{
		i_pid = p_sys->i_pid_spu;
		p_sys->i_pid_spu = 0;
	}
	else
	{
		i_pid = ++p_sys->i_pid_free;
	}
	return i_pid;
}


static block_t * WritePSISection( dvbpsi_psi_section_t* p_section )
{
	block_t   *p_psi, *p_first = NULL;
	
	while( p_section )
	{
		int   i_size;

		i_size =  (uint32_t)( p_section->p_payload_end - p_section->p_data )+
			( p_section->b_syntax_indicator ? 4 : 0 );

		p_psi = new block_t();	p_psi->AllocateBuffer(i_size + 1 ); //p_psi = block_New( p_sout, i_size + 1 );
		p_psi->i_pts = 0;
		p_psi->i_dts = 0;
		p_psi->i_length = 0;
		p_psi->m_nDataSize/*i_buffer*/ = i_size + 1;

		p_psi->m_pData/*p_buffer*/[0] = 0; /* pointer */
		memcpy( p_psi->m_pData/*p_buffer*/ + 1,
			p_section->p_data,
			i_size );

		block_ChainAppend( &p_first, p_psi );

		p_section = p_section->p_next;
	}
	 
	return( p_first );
}

static block_t *Add_ADTS( block_t *p_data, es_format_t *p_fmt )
{
	uint8_t *p_extra = (uint8_t *)p_fmt->p_extra;

	if( !p_data || p_fmt->i_extra < 2 || !p_extra )
		return p_data; /* no data to construct the headers */

	int i_index = ( (p_extra[0] << 1) | (p_extra[1] >> 7) ) & 0x0f;
	int i_profile = (p_extra[0] >> 3) - 1; /* i_profile < 4 */

	if( i_index == 0x0f && p_fmt->i_extra < 5 )
		return p_data; /* not enough data */

	int i_channels = (p_extra[i_index == 0x0f ? 4 : 1] >> 3) & 0x0f;

	#define ADTS_HEADER_SIZE 7 /* CRC needs 2 more bytes */

	/* keep a copy in case block_Realloc() fails */
	block_t *p_bak_block = new block_t();
	if (!p_bak_block)
		return p_data;

	*p_bak_block = *p_data;

	p_bak_block->m_nBufferSize = p_data->m_nDataSize;
	p_bak_block->m_pBuffer = new BYTE[p_data->m_nDataSize];
	if (!p_bak_block->m_pBuffer)
		return p_data;

	memcpy(p_bak_block->m_pBuffer, p_data->m_pData, p_data->m_nDataSize);

	p_bak_block->m_pData = p_bak_block->m_pBuffer;
	p_bak_block->m_nDataSize = p_bak_block->m_nBufferSize;
	//block_t *p_bak_block = block_Duplicate( p_data );

	if( !p_bak_block ) /* OOM, block_Realloc() is likely to lose our block */
		return p_data; /* the frame isn't correct but that's the best we have */

	block_t *p_new_block = new block_t();
	if (!p_new_block)
		return p_data;
	
	*p_new_block = *p_data;

	p_new_block->m_nBufferSize = ADTS_HEADER_SIZE + p_data->m_nDataSize;
	p_new_block->m_pBuffer = new BYTE[p_new_block->m_nBufferSize];
	if (!p_new_block->m_pBuffer)
		return p_data;

	memcpy(p_new_block->m_pBuffer+ADTS_HEADER_SIZE, p_data->m_pData, p_data->m_nDataSize);

	p_new_block->m_pData = p_new_block->m_pBuffer;
	p_new_block->m_nDataSize = p_new_block->m_nBufferSize;
	//block_t *p_new_block = block_Realloc( p_data, ADTS_HEADER_SIZE,
	//	p_data->i_buffer );

	if( !p_new_block )
		return p_bak_block; /* OOM, send the (incorrect) original frame */

	delete p_bak_block;//block_Release( p_bak_block ); /* we don't need the copy anymore */


	uint8_t *p_buffer = p_new_block->m_pData/*p_buffer*/;

	/* fixed header */
	p_buffer[0] = 0xff;
	p_buffer[1] = 0xf1; /* 0xf0 | 0x00 | 0x00 | 0x01 */
	p_buffer[2] = (i_profile << 6) | ((i_index & 0x0f) << 2) | ((i_channels >> 2) & 0x01) ;
	p_buffer[3] = (i_channels << 6) | ((p_data->m_nDataSize/*i_buffer*/ >> 11) & 0x03);

	/* variable header (starts at last 2 bits of 4th byte) */

	int i_fullness = 0x7ff; /* 0x7ff means VBR */
	/* XXX: We should check if it's CBR or VBR, but no known implementation
	* do that, and it's a pain to calculate this field */

	p_buffer[4] = p_data->m_nDataSize/*i_buffer*/ >> 3;
	p_buffer[5] = ((p_data->m_nDataSize/*i_buffer*/ & 0x07) << 5) | ((i_fullness >> 6) & 0x1f);
	p_buffer[6] = ((i_fullness & 0x3f) << 2) /* | 0xfc */;

	delete p_data;

	return p_new_block;
}

#define STD_PES_PAYLOAD 170
static block_t *FixPES( mux_t *p_mux, block_fifo_t *p_fifo )
{
	block_t *p_data;
	size_t i_size;

	p_data = (block_t *)p_fifo->GetFullBufferShadow();//block_FifoShow( p_fifo );
	i_size = p_data->m_nDataSize/*i_buffer*/;

	if( i_size == STD_PES_PAYLOAD )
	{
		return (block_t *)p_fifo->GetFullBuffer();//block_FifoGet( p_fifo );
	}
	else if( i_size > STD_PES_PAYLOAD )
	{
		block_t *p_new = new block_t(); //block_New( p_mux, STD_PES_PAYLOAD );
		p_new->FillData(p_data->m_pData, STD_PES_PAYLOAD);//vlc_memcpy( p_new->p_buffer, p_data->p_buffer, STD_PES_PAYLOAD );

		p_new->i_pts = p_data->i_pts;
		p_new->i_dts = p_data->i_dts;
		p_new->i_length = p_data->i_length * STD_PES_PAYLOAD
			/ p_data->m_nDataSize/*i_buffer*/;
		p_data->m_nDataSize/*i_buffer*/ -= STD_PES_PAYLOAD;
		p_data->m_pData/*p_buffer*/ += STD_PES_PAYLOAD;
		p_data->i_pts += p_new->i_length;
		p_data->i_dts += p_new->i_length;
		p_data->i_length -= p_new->i_length;
		p_data->i_flags |= BLOCK_FLAG_NO_KEYFRAME;
		return p_new;
	}
	else
	{
		block_t *p_next;
		int i_copy;

		p_data = (block_t *)p_fifo->GetFullBuffer();	//block_FifoGet( p_fifo );
		
		Buffer buffer_temp;
		buffer_temp.FillData(p_data->m_pData, p_data->m_nDataSize);
		p_data->ExtendBuffer(STD_PES_PAYLOAD);
		p_data->FillData(buffer_temp.m_pData, buffer_temp.m_nDataSize);	//p_data = block_Realloc( p_data, 0, STD_PES_PAYLOAD );
		
		p_next = (block_t *)p_fifo->GetFullBufferShadow();//block_FifoShow( p_fifo );

		if ( p_data->i_flags & BLOCK_FLAG_NO_KEYFRAME )
		{
			p_data->i_flags &= ~BLOCK_FLAG_NO_KEYFRAME;
			p_data->i_pts = p_next->i_pts;
			p_data->i_dts = p_next->i_dts;
		}
		i_copy = __MIN( STD_PES_PAYLOAD - i_size, p_next->m_nDataSize/*i_buffer*/ );

		p_data->AppendData(p_next->m_pData, i_copy);//vlc_memcpy( &p_data->p_buffer[i_size], p_next->p_buffer, i_copy );
		p_next->i_pts += p_next->i_length * i_copy / p_next->m_nDataSize/*i_buffer*/;
		p_next->i_dts += p_next->i_length * i_copy / p_next->m_nDataSize/*i_buffer*/;
		p_next->i_length -= p_next->i_length * i_copy / p_next->m_nDataSize/*i_buffer*/;
		p_next->m_nDataSize/*i_buffer*/ -= i_copy;
		p_next->m_pData/*p_buffer*/ += i_copy;
		p_next->i_flags |= BLOCK_FLAG_NO_KEYFRAME;

		if( !p_next->m_nDataSize/*i_buffer*/ )
		{
			p_next = (block_t *)p_fifo->GetFullBuffer();//block_FifoGet( p_fifo );
			delete p_next;//block_Release( p_next );
		}
		return p_data;
	}
}

static void PEStoTS( buffer_chain_t *c, block_t *p_pes,
					ts_stream_t *p_stream )

{
	uint8_t *p_data;
	int     i_size;
	int     b_new_pes;

	/* get PES total size */
	i_size = p_pes->m_nDataSize/*i_buffer*/;;
	p_data = p_pes->m_pData/*p_buffer*/;

	b_new_pes = true;

	for( ;; )
	{
		int           b_adaptation_field;
		int           i_copy;
		block_t *p_ts;

		p_ts = new block_t();p_ts->AllocateBuffer(188);p_ts->m_nDataSize = 188;//p_ts = block_New( p_sout, 188 );

		/* write header
		* 8b   0x47    sync byte
		* 1b           transport_error_indicator
		* 1b           payload_unit_start
		* 1b           transport_priority
		* 13b          pid
		* 2b           transport_scrambling_control
		* 2b           if adaptation_field 0x03 else 0x01
		* 4b           continuity_counter
		*/

		i_copy    = __MIN( i_size, 184 );
		b_adaptation_field = i_size < 184 ? true : false;

		p_ts->m_pData/*p_buffer*/[0] = 0x47;
		p_ts->m_pData/*p_buffer*/[1] = ( b_new_pes ? 0x40 : 0x00 )|
			( ( p_stream->i_pid >> 8 )&0x1f );
		p_ts->m_pData/*p_buffer*/[2] = p_stream->i_pid & 0xff;
		p_ts->m_pData/*p_buffer*/[3] = ( b_adaptation_field ? 0x30 : 0x10 )|
			p_stream->i_continuity_counter;

		b_new_pes = false;
		p_stream->i_continuity_counter = (p_stream->i_continuity_counter+1)%16;

		if( b_adaptation_field )
		{
			int i_stuffing = 184 - i_copy;
			int i;

			p_ts->m_pData/*p_buffer*/[4] = i_stuffing - 1;
			if( i_stuffing > 1 )
			{
				p_ts->m_pData/*p_buffer*/[5] = 0x00;
				if( p_stream->b_discontinuity )
				{
					p_ts->m_pData/*p_buffer*/[5] |= 0x80;
					p_stream->b_discontinuity = false;
				}
				for( i = 6; i < 6 + i_stuffing - 2; i++ )
				{
					p_ts->m_pData/*p_buffer*/[i] = 0xff;
				}
			}
		}
		/* copy payload */
		memcpy( &p_ts->m_pData/*p_buffer*/[188 - i_copy], p_data, i_copy );
		p_data += i_copy;
		i_size -= i_copy;

		BufferChainAppend( c, p_ts );

		if( i_size <= 0 )
		{
			block_t *p_next = p_pes->p_next;

			p_pes->p_next = NULL;
			delete p_pes;//block_Release( p_pes );
			if( p_next == NULL )
			{
				break;
			}
			b_new_pes = true;
			p_pes = p_next;
			i_size = p_pes->m_nDataSize/*i_buffer*/;
			p_data = p_pes->m_pData/*p_buffer*/;
		}
	}
	return;
}

static void GetPAT( mux_t *p_mux, 
				   buffer_chain_t *c )
{
	mux_sys_t				*p_sys = p_mux->p_sys;
	block_t				    *p_pat;
	dvbpsi_pat_t			pat;
	dvbpsi_psi_section_t	*p_section;
	int i;

	dvbpsi_InitPAT( &pat, p_sys->i_tsid, p_sys->i_pat_version_number,
		1 );      /* b_current_next */
	/* add all programs */
	for ( i = 0; i < p_sys->i_num_pmt; i++ )
		dvbpsi_PATAddProgram( &pat,
		p_sys->i_pmt_program_number[i],
		p_sys->pmt[i].i_pid );

	p_section = dvbpsi_GenPATSections( &pat,
		0 );     /* max program per section */


	p_pat = WritePSISection( p_section );
	PEStoTS(c, p_pat, &p_sys->pat );

	dvbpsi_DeletePSISections( p_section );
	dvbpsi_EmptyPAT( &pat );
}

static void GetPMT( mux_t *p_mux, buffer_chain_t *c )
{
	mux_sys_t  *p_sys = p_mux->p_sys;
	block_t   *p_pmt[MAX_PMT];

	dvbpsi_pmt_es_t			*p_es;
	dvbpsi_psi_section_t	*p_section[MAX_PMT];

	int             i_pidinput;
	int             i_stream;
	int             i;
	int             *p_usepid = NULL;

#ifdef HAVE_DVBPSI_SDT
	block_t         *p_sdt;
	dvbpsi_sdt_t    sdt;

	dvbpsi_psi_section_t* p_section2;
	dvbpsi_sdt_service_t *p_service;

	uint8_t         *psz_sdt_desc;
#endif

	if( p_sys->dvbpmt == NULL )
	{
		p_sys->dvbpmt = (dvbpsi_pmt_t *)malloc( p_sys->i_num_pmt * sizeof(dvbpsi_pmt_t) );
		if( !p_sys->dvbpmt )
		{
			return;
		}
	}
#ifdef HAVE_DVBPSI_SDT
	if( p_sys->b_sdt )
		dvbpsi_InitSDT( &sdt, p_sys->i_tsid, 1, 1, p_sys->i_netid );
#endif

	for( i = 0; i < p_sys->i_num_pmt; i++ )
	{
		dvbpsi_InitPMT( &p_sys->dvbpmt[i],
			p_sys->i_pmt_program_number[i],   /* program number */
			p_sys->i_pmt_version_number,
			1,      /* b_current_next */
			p_sys->i_pcr_pid );

#ifdef HAVE_DVBPSI_SDT
		if( p_sys->b_sdt )
		{
			p_service = dvbpsi_SDTAddService( &sdt,
				p_sys->i_pmt_program_number[i],  /* service id */
				0,         /* eit schedule */
				0,         /* eit present */
				4,         /* running status ("4=RUNNING") */
				0 );       /* free ca */

#define psz_sdtprov p_sys->sdt_descriptors[i].psz_provider
#define psz_sdtserv p_sys->sdt_descriptors[i].psz_service_name

			/* FIXME: Ineffecient malloc's & ugly code......  */
			if( ( psz_sdtprov != NULL ) && ( psz_sdtserv != NULL ) )
			{
				psz_sdt_desc = (uint8_t *)malloc( 3 + strlen(psz_sdtprov)
					+ strlen(psz_sdtserv) );
				if( psz_sdt_desc )
				{
					psz_sdt_desc[0] = 0x01; /* digital television service */

					/* service provider name length */
					psz_sdt_desc[1] = (char)strlen(psz_sdtprov);
					memcpy( &psz_sdt_desc[2], psz_sdtprov, strlen(psz_sdtprov) );

					/* service name length */
					psz_sdt_desc[ 2 + strlen(psz_sdtprov) ]
					= (char)strlen(psz_sdtserv);
					memcpy( &psz_sdt_desc[3+strlen(psz_sdtprov)], psz_sdtserv,
						strlen(psz_sdtserv) );

					dvbpsi_SDTServiceAddDescriptor( p_service, 0x48,
						3 + strlen(psz_sdtprov) + strlen(psz_sdtserv),
						(uint8_t *)psz_sdt_desc );
					free( psz_sdt_desc );
					psz_sdt_desc = NULL;
				}
			}
#undef psz_sdtprov
#undef psz_sdtserv
		}
#endif
	}

	if( p_sys->i_mpeg4_streams > 0 )
	{
		uint8_t iod[4096];
		bits_buffer_t bits;
		bits_buffer_t bits_fix_IOD;

		/* Make valgrind happy : it works at byte level not bit one so
		* bit_write confuse it (but DON'T CHANGE the way that bit_write is
		* working (needed when fixing some bits) */
		memset( iod, 0, 4096 );

		bits_initwrite( &bits, 4096, iod );
		/* IOD_label_scope */
		bits_write( &bits, 8,   0x11 );
		/* IOD_label */
		bits_write( &bits, 8,   0x01 );
		/* InitialObjectDescriptor */
		bits_align( &bits );
		bits_write( &bits, 8,   0x02 );     /* tag */
		bits_fix_IOD = bits;    /* save states to fix length later */
		bits_write( &bits, 24,
			GetDescriptorLength24b( 0 ) );  /* variable length (fixed later) */
		bits_write( &bits, 10,  0x01 );     /* ObjectDescriptorID */
		bits_write( &bits, 1,   0x00 );     /* URL Flag */
		bits_write( &bits, 1,   0x00 );     /* includeInlineProfileLevelFlag */
		bits_write( &bits, 4,   0x0f );     /* reserved */
		bits_write( &bits, 8,   0xff );     /* ODProfile (no ODcapability ) */
		bits_write( &bits, 8,   0xff );     /* sceneProfile */
		bits_write( &bits, 8,   0xfe );     /* audioProfile (unspecified) */
		bits_write( &bits, 8,   0xfe );     /* visualProfile( // ) */
		bits_write( &bits, 8,   0xff );     /* graphicProfile (no ) */

		for( i_stream = 0; i_stream < p_mux->i_nb_inputs; i_stream++ )
		{
			ts_stream_t *p_stream;
			p_stream = (ts_stream_t*)p_mux->pp_inputs[i_stream]->p_sys;

			if( p_stream->i_stream_id == 0xfa ||
				p_stream->i_stream_id == 0xfb ||
				p_stream->i_stream_id == 0xfe )
			{
				bits_buffer_t bits_fix_ESDescr, bits_fix_Decoder;
				/* ES descriptor */
				bits_align( &bits );
				bits_write( &bits, 8,   0x03 );     /* ES_DescrTag */
				bits_fix_ESDescr = bits;
				bits_write( &bits, 24,
					GetDescriptorLength24b( 0 ) ); /* variable size */
				bits_write( &bits, 16,  p_stream->i_es_id );
				bits_write( &bits, 1,   0x00 );     /* streamDependency */
				bits_write( &bits, 1,   0x00 );     /* URL Flag */
				bits_write( &bits, 1,   0x00 );     /* OCRStreamFlag */
				bits_write( &bits, 5,   0x1f );     /* streamPriority */

				/* DecoderConfigDesciptor */
				bits_align( &bits );
				bits_write( &bits, 8,   0x04 ); /* DecoderConfigDescrTag */
				bits_fix_Decoder = bits;
				bits_write( &bits, 24,  GetDescriptorLength24b( 0 ) );
				if( p_stream->i_stream_type == 0x10 )
				{
					bits_write( &bits, 8, 0x20 );   /* Visual 14496-2 */
					bits_write( &bits, 6, 0x04 );   /* VisualStream */
				}
				else if( p_stream->i_stream_type == 0x1b )
				{
					bits_write( &bits, 8, 0x21 );   /* Visual 14496-2 */
					bits_write( &bits, 6, 0x04 );   /* VisualStream */
				}
				else if( p_stream->i_stream_type == 0x11 ||
					p_stream->i_stream_type == 0x0f )
				{
					bits_write( &bits, 8, 0x40 );   /* Audio 14496-3 */
					bits_write( &bits, 6, 0x05 );   /* AudioStream */
				}
				else if( p_stream->i_stream_type == 0x12 &&
					p_stream->i_codec == FOURCC('s','u','b','t') )
				{
					bits_write( &bits, 8, 0x0B );   /* Text Stream */
					bits_write( &bits, 6, 0x04 );   /* VisualStream */
				}
				else
				{
					bits_write( &bits, 8, 0x00 );
					bits_write( &bits, 6, 0x00 );

					//msg_Err( p_mux->p_sout,"Unsupported stream_type => "
					//	"broken IOD" );
				}
				bits_write( &bits, 1,   0x00 );         /* UpStream */
				bits_write( &bits, 1,   0x01 );         /* reserved */
				bits_write( &bits, 24,  1024 * 1024 );  /* bufferSizeDB */
				bits_write( &bits, 32,  0x7fffffff );   /* maxBitrate */
				bits_write( &bits, 32,  0 );            /* avgBitrate */

				if( p_stream->i_decoder_specific_info > 0 )
				{
					int i;
					/* DecoderSpecificInfo */
					bits_align( &bits );
					bits_write( &bits, 8,   0x05 ); /* tag */
					bits_write( &bits, 24, GetDescriptorLength24b(
						p_stream->i_decoder_specific_info ) );
					for( i = 0; i < p_stream->i_decoder_specific_info; i++ )
					{
						bits_write( &bits, 8,
							((uint8_t*)p_stream->p_decoder_specific_info)[i] );
					}
				}
				/* fix Decoder length */
				bits_write( &bits_fix_Decoder, 24,
					GetDescriptorLength24b( bits.i_data -
					bits_fix_Decoder.i_data - 3 ) );

				/* SLConfigDescriptor : predefined (0x01) */
				bits_align( &bits );
				bits_write( &bits, 8,   0x06 ); /* tag */
				bits_write( &bits, 24,  GetDescriptorLength24b( 8 ) );
				bits_write( &bits, 8,   0x01 );/* predefined */
				bits_write( &bits, 1,   0 );   /* durationFlag */
				bits_write( &bits, 32,  0 );   /* OCRResolution */
				bits_write( &bits, 8,   0 );   /* OCRLength */
				bits_write( &bits, 8,   0 );   /* InstantBitrateLength */
				bits_align( &bits );

				/* fix ESDescr length */
				bits_write( &bits_fix_ESDescr, 24,
					GetDescriptorLength24b( bits.i_data -
					bits_fix_ESDescr.i_data - 3 ) );
			}
		}
		bits_align( &bits );
		/* fix IOD length */
		bits_write( &bits_fix_IOD, 24,
			GetDescriptorLength24b( bits.i_data -
			bits_fix_IOD.i_data - 3 ) );

#if 0//def HAVE_BSEARCH /* FIXME!!! This can't possibly work */
		i_pidinput = p_mux->pp_inputs[i]->p_fmt->i_id;
		p_usepid = bsearch( &i_pidinput, p_sys->pmtmap, p_sys->i_pmtslots,
			sizeof(pmt_map_t), intcompare );
		p_usepid = bsearch( &p_usepid, p_sys->pmtmap, p_sys->i_num_pmt,
			sizeof(pmt_map_t), pmtcompare );
		if( p_usepid != NULL )
			dvbpsi_PMTAddDescriptor(
			&p_sys->dvbpmt[((pmt_map_t *)p_usepid)->i_prog], 0x1d,
			bits.i_data, bits.p_data );
		else
			msg_Err( p_mux, "Received an unmapped PID" );
#else
		dvbpsi_PMTAddDescriptor( &p_sys->dvbpmt[0], 0x1d, bits.i_data,
			bits.p_data );
#endif
	}

	for( i_stream = 0; i_stream < p_mux->i_nb_inputs; i_stream++ )
	{
		ts_stream_t *p_stream;

		p_stream = (ts_stream_t *)p_mux->pp_inputs[i_stream]->p_sys;

#ifdef HAVE_BSEARCH
		i_pidinput = p_mux->pp_inputs[i_stream]->p_fmt->i_id;

		p_usepid = (int *)bsearch( &i_pidinput, p_sys->pmtmap, p_sys->i_pmtslots,
			sizeof(pmt_map_t), intcompare );

		if( p_usepid != NULL )
			p_es = dvbpsi_PMTAddES(
			&p_sys->dvbpmt[((pmt_map_t *)p_usepid)->i_prog],
			p_stream->i_stream_type, p_stream->i_pid );
		else
			/* If there's an error somewhere, dump it to the first pmt */
#endif
			p_es = dvbpsi_PMTAddES( &p_sys->dvbpmt[0], p_stream->i_stream_type,
			p_stream->i_pid );

		if( p_stream->i_stream_id == 0xfa || p_stream->i_stream_id == 0xfb )
		{
			uint8_t     es_id[2];

			/* SL descriptor */
			es_id[0] = (p_stream->i_es_id >> 8)&0xff;
			es_id[1] = (p_stream->i_es_id)&0xff;
			dvbpsi_PMTESAddDescriptor( p_es, 0x1f, 2, es_id );
		}
		else if( p_stream->i_stream_type == 0xa0 )
		{
			uint8_t data[512];
			int i_extra = __MIN( p_stream->i_decoder_specific_info, 502 );

			/* private DIV3 descripor */
			memcpy( &data[0], &p_stream->i_bih_codec, 4 );
			data[4] = ( p_stream->i_bih_width >> 8 )&0xff;
			data[5] = ( p_stream->i_bih_width      )&0xff;
			data[6] = ( p_stream->i_bih_height>> 8 )&0xff;
			data[7] = ( p_stream->i_bih_height     )&0xff;
			data[8] = ( i_extra >> 8 )&0xff;
			data[9] = ( i_extra      )&0xff;
			if( i_extra > 0 )
			{
				memcpy( &data[10], p_stream->p_decoder_specific_info, i_extra );
			}

			/* 0xa0 is private */
			dvbpsi_PMTESAddDescriptor( p_es, 0xa0, i_extra + 10, data );
		}
		else if( p_stream->i_stream_type == 0x81 )
		{
			uint8_t format[4] = { 0x41, 0x43, 0x2d, 0x33 };

			/* "registration" descriptor : "AC-3" */
			dvbpsi_PMTESAddDescriptor( p_es, 0x05, 4, format );
		}
		else if( p_stream->i_codec == FOURCC('d','t','s',' ') )
		{
			/* DTS registration descriptor (ETSI TS 101 154 Annex F) */

			/* DTS format identifier, frame size 1024 - FIXME */
			uint8_t data[4] = { 0x44, 0x54, 0x53, 0x32 };
			dvbpsi_PMTESAddDescriptor( p_es, 0x05, 4, data );
		}
		else if( p_stream->i_codec == FOURCC('t','e','l','x') )
		{
			if( p_stream->i_decoder_specific_info )
			{
				dvbpsi_PMTESAddDescriptor( p_es, 0x56,
					p_stream->i_decoder_specific_info,
					p_stream->p_decoder_specific_info );
			}
			continue;
		}
		else if( p_stream->i_codec == FOURCC('d','v','b','s') )
		{
			/* DVB subtitles */
			if( p_stream->i_decoder_specific_info )
			{
				/* pass-through from the TS demux */
				dvbpsi_PMTESAddDescriptor( p_es, 0x59,
					p_stream->i_decoder_specific_info,
					p_stream->p_decoder_specific_info );
			}
#ifdef _DVBPSI_DR_59_H_
			else
			{
				/* from the dvbsub transcoder */
				dvbpsi_subtitling_dr_t descr;
				dvbpsi_subtitle_t sub;
				dvbpsi_descriptor_t *p_descr;

				memcpy( sub.i_iso6392_language_code, p_stream->lang, 3 );
				sub.i_subtitling_type = 0x10; /* no aspect-ratio criticality */
				sub.i_composition_page_id = p_stream->i_es_id & 0xFF;
				sub.i_ancillary_page_id = p_stream->i_es_id >> 16;

				descr.i_subtitles_number = 1;
				descr.p_subtitle[0] = sub;

				p_descr = dvbpsi_GenSubtitlingDr( &descr, 0 );
				/* Work around bug in old libdvbpsi */ p_descr->i_length = 8;
				dvbpsi_PMTESAddDescriptor( p_es, p_descr->i_tag,
					p_descr->i_length, p_descr->p_data );
			}
#endif /* _DVBPSI_DR_59_H_ */
			continue;
		}

		if( p_stream->lang[0] != 0 )
		{
			uint8_t *p_data = (uint8_t *)malloc(4*p_stream->i_langs);	//uint8_t data[4*p_stream->i_langs];

			/* I construct the content myself, way faster than looking at
			* over complicated/mind broken libdvbpsi way */
			for(i = 0; i < p_stream->i_langs; i++ )
			{
				p_data/*data*/[i*4+0] = p_stream->lang[i*3+0];
				p_data/*data*/[i*4+1] = p_stream->lang[i*3+1];
				p_data/*data*/[i*4+2] = p_stream->lang[i*3+2];
				p_data/*data*/[i*4+3] = 0x00; /* audio type: 0x00 undefined */
			}
			dvbpsi_PMTESAddDescriptor( p_es, 0x0a, 4*p_stream->i_langs, p_data/*data*/ );
			free(p_data);
		}
	}

	for( i = 0; i < p_sys->i_num_pmt; i++ )
	{
		p_section[i] = dvbpsi_GenPMTSections( &p_sys->dvbpmt[i] );
		p_pmt[i] = WritePSISection( /*p_mux->p_sout,*/ p_section[i] );
		PEStoTS( /*p_mux->p_sout,*/ c, p_pmt[i], &p_sys->pmt[i] );
		dvbpsi_DeletePSISections( p_section[i] );
		dvbpsi_EmptyPMT( &p_sys->dvbpmt[i] );
	}

#ifdef HAVE_DVBPSI_SDT
	if( p_sys->b_sdt )
	{
		p_section2 = dvbpsi_GenSDTSections( &sdt );
		p_sdt = WritePSISection( /*p_mux->p_sout,*/ p_section2 );
		PEStoTS( /*p_mux->p_sout,*/ c, p_sdt, &p_sys->sdt );
		dvbpsi_DeletePSISections( p_section2 );
		dvbpsi_EmptySDT( &sdt );
	}
#endif
}

static block_t *TSNew( mux_t *p_mux, ts_stream_t *p_stream,  bool_t b_pcr )
{
	block_t *p_pes = p_stream->chain_pes.p_first;
	block_t *p_ts;

	bool_t b_new_pes = 0;
	bool_t b_adaptation_field = 0;

	int i_payload_max = 184 - ( b_pcr ? 8 : 0 );
	int i_payload;

	if( p_stream->i_pes_used <= 0 )
	{
		b_new_pes = 1;
	}
	i_payload = __MIN( (int)p_pes->m_nDataSize/*i_buffer*/ - p_stream->i_pes_used,
		i_payload_max );

	if( b_pcr || i_payload < i_payload_max )
	{
		b_adaptation_field = 1;
	}

	p_ts = new block_t(); p_ts->AllocateBuffer(188);p_ts->m_nDataSize = 188;//p_ts = block_New( p_mux, 188 );
	p_ts->i_dts = p_pes->i_dts;

	p_ts->m_pData/*p_buffer*/[0] = 0x47;
	p_ts->m_pData/*p_buffer*/[1] = ( b_new_pes ? 0x40 : 0x00 ) |
		( ( p_stream->i_pid >> 8 )&0x1f );
	p_ts->m_pData/*p_buffer*/[2] = p_stream->i_pid & 0xff;
	p_ts->m_pData/*p_buffer*/[3] = ( b_adaptation_field ? 0x30 : 0x10 ) |
		p_stream->i_continuity_counter;

	p_stream->i_continuity_counter = (p_stream->i_continuity_counter+1)%16;
	p_stream->b_discontinuity = (p_pes->i_flags & BLOCK_FLAG_DISCONTINUITY);

	if( b_adaptation_field )
	{
		int i;

		if( b_pcr )
		{
			int     i_stuffing = i_payload_max - i_payload;

			p_ts->i_flags |= BLOCK_FLAG_CLOCK;

			p_ts->m_pData/*p_buffer*/[4] = 7 + i_stuffing;
			p_ts->m_pData/*p_buffer*/[5] = 0x10;   /* flags */
			if( p_stream->b_discontinuity )
			{
				p_ts->m_pData/*p_buffer*/[5] |= 0x80; /* flag TS dicontinuity */
				p_stream->b_discontinuity = false;
			}
			p_ts->m_pData/*p_buffer*/[6] = ( 0 )&0xff;
			p_ts->m_pData/*p_buffer*/[7] = ( 0 )&0xff;
			p_ts->m_pData/*p_buffer*/[8] = ( 0 )&0xff;
			p_ts->m_pData/*p_buffer*/[9] = ( 0 )&0xff;
			p_ts->m_pData/*p_buffer*/[10]= ( ( 0 )&0x80 ) | 0x7e;
			p_ts->m_pData/*p_buffer*/[11]= 0;

			for( i = 12; i < 12 + i_stuffing; i++ )
			{
				p_ts->m_pData/*p_buffer*/[i] = 0xff;
			}
		}
		else
		{
			int i_stuffing = i_payload_max - i_payload;

			p_ts->m_pData/*p_buffer*/[4] = i_stuffing - 1;
			if( i_stuffing > 1 )
			{
				p_ts->m_pData/*p_buffer*/[5] = 0x00;
				for( i = 6; i < 6 + i_stuffing - 2; i++ )
				{
					p_ts->m_pData/*p_buffer*/[i] = 0xff;
				}
			}
		}
	}

	/* copy payload */
	memcpy( &p_ts->m_pData/*p_buffer*/[188 - i_payload],
		&p_pes->m_pData/*p_buffer*/[p_stream->i_pes_used], i_payload );

	p_stream->i_pes_used += i_payload;
	p_stream->i_pes_dts = p_pes->i_dts + p_pes->i_length *
		p_stream->i_pes_used / p_pes->m_nDataSize/*i_buffer*/;
	p_stream->i_pes_length -= p_pes->i_length * i_payload / p_pes->m_nDataSize/*i_buffer*/;

	if( p_stream->i_pes_used >= (int)p_pes->m_nDataSize/*i_buffer*/ )
	{
		p_pes = BufferChainGet( &p_stream->chain_pes );
		delete p_pes;//block_Release( p_pes );

		p_pes = p_stream->chain_pes.p_first;
		if( p_pes )
		{
			p_stream->i_pes_dts    = p_pes->i_dts;
			p_stream->i_pes_length = 0;
			while( p_pes )
			{
				p_stream->i_pes_length += p_pes->i_length;

				p_pes = p_pes->p_next;
			}
		}
		else
		{
			p_stream->i_pes_dts = 0;
			p_stream->i_pes_length = 0;
		}
		p_stream->i_pes_used = 0;
	}

	return p_ts;
}

static void TSSetPCR( block_t *p_ts, mtime_t i_dts )
{
	mtime_t i_pcr = 9 * i_dts / 100;

	p_ts->m_pData/*p_buffer*/[6]  = ( i_pcr >> 25 )&0xff;
	p_ts->m_pData/*p_buffer*/[7]  = ( i_pcr >> 17 )&0xff;
	p_ts->m_pData/*p_buffer*/[8]  = ( i_pcr >> 9  )&0xff;
	p_ts->m_pData/*p_buffer*/[9]  = ( i_pcr >> 1  )&0xff;
	p_ts->m_pData/*p_buffer*/[10]|= ( i_pcr << 7  )&0x80;
}


static void TSDate( mux_t *p_mux, buffer_chain_t *p_chain_ts,
				   mtime_t i_pcr_length, mtime_t i_pcr_dts )
{
	mux_sys_t  *p_sys = p_mux->p_sys;
	int i_packet_count = p_chain_ts->i_depth;
	int i;

	if ( i_pcr_length / 1000 > 0 )
	{
		int i_bitrate = (int)(((uint64_t)i_packet_count * 188 * 8000)
			/ (uint64_t)(i_pcr_length / 1000));
		if ( p_sys->i_bitrate_max && p_sys->i_bitrate_max < i_bitrate )
		{
			printf("max bitrate exceeded at %I64d"
				" (%d bi/s for %d pkt in %I64d us)",
				i_pcr_dts + p_sys->i_shaping_delay * 3 / 2 - mdate(),
				i_bitrate, i_packet_count, i_pcr_length);
			//msg_Warn( p_mux, "max bitrate exceeded at %"PRId64
			//	" (%d bi/s for %d pkt in %"PRId64" us)",
			//	i_pcr_dts + p_sys->i_shaping_delay * 3 / 2 - mdate(),
			//	i_bitrate, i_packet_count, i_pcr_length);
		}
#if 0
		else
		{
			msg_Dbg( p_mux, "starting at %"PRId64
				" (%d bi/s for %d packets in %"PRId64" us)",
				i_pcr_dts + p_sys->i_shaping_delay * 3 / 2 - mdate(),
				i_bitrate, i_packet_count, i_pcr_length);
		}
#endif
	}
	else
	{
		/* This shouldn't happen, but happens in some rare heavy load
		* and packet losses conditions. */
		i_pcr_length = i_packet_count;
	}

	/* msg_Dbg( p_mux, "real pck=%d", i_packet_count ); */
	for( i = 0; i < i_packet_count; i++ )
	{
		block_t *p_ts = BufferChainGet( p_chain_ts );
		mtime_t i_new_dts = i_pcr_dts + i_pcr_length * i / i_packet_count;

		p_ts->i_dts    = i_new_dts;
		p_ts->i_length = i_pcr_length / i_packet_count;

		if( p_ts->i_flags & BLOCK_FLAG_CLOCK )
		{
			/* msg_Dbg( p_mux, "pcr=%lld ms", p_ts->i_dts / 1000 ); */
			TSSetPCR( p_ts, p_ts->i_dts - p_sys->i_dts_delay );
		}
		if( p_ts->i_flags & BLOCK_FLAG_SCRAMBLED )
		{
			p_sys->csa_lock->Lock();//vlc_mutex_lock( &p_sys->csa_lock );
			csa_Encrypt( p_sys->csa, p_ts->m_pData/*p_buffer*/, p_sys->i_csa_pkt_size, 0 );
			p_sys->csa_lock->UnLock();//vlc_mutex_unlock( &p_sys->csa_lock );
		}

		/* latency */
		p_ts->i_dts += p_sys->i_shaping_delay * 3 / 2;

		//sout_AccessOutWrite( p_mux->p_access, p_ts );
		p_mux->p_access(p_mux->p_access_user_data, p_ts->m_pData, p_ts->m_nDataSize);
		delete p_ts;
	}
}

static void TSSchedule( mux_t *p_mux, buffer_chain_t *p_chain_ts,
					   mtime_t i_pcr_length, mtime_t i_pcr_dts )
{
	mux_sys_t  *p_sys = p_mux->p_sys;
	buffer_chain_t new_chain;
	int i_packet_count = p_chain_ts->i_depth;
	int i;

	BufferChainInit( &new_chain );

	if ( i_pcr_length <= 0 )
	{
		i_pcr_length = i_packet_count;
	}

	for( i = 0; i < i_packet_count; i++ )
	{
		block_t *p_ts = BufferChainGet( p_chain_ts );
		mtime_t i_new_dts = i_pcr_dts + i_pcr_length * i / i_packet_count;

		BufferChainAppend( &new_chain, p_ts );

		if( p_ts->i_dts &&
			p_ts->i_dts + p_sys->i_dts_delay * 2/3 < i_new_dts )
		{
			mtime_t i_max_diff = i_new_dts - p_ts->i_dts;
			mtime_t i_cut_dts = p_ts->i_dts;

			p_ts = BufferChainPeek( p_chain_ts );
			i++;
			i_new_dts = i_pcr_dts + i_pcr_length * i / i_packet_count;
			while ( p_ts != NULL && i_new_dts - p_ts->i_dts >= i_max_diff )
			{
				p_ts = BufferChainGet( p_chain_ts );
				i_max_diff = i_new_dts - p_ts->i_dts;
				i_cut_dts = p_ts->i_dts;
				BufferChainAppend( &new_chain, p_ts );

				p_ts = BufferChainPeek( p_chain_ts );
				i++;
				i_new_dts = i_pcr_dts + i_pcr_length * i / i_packet_count;
			}
			//msg_Dbg( p_mux, "adjusting rate at %"PRId64"/%"PRId64" (%d/%d)",
			//	i_cut_dts - i_pcr_dts, i_pcr_length, new_chain.i_depth,
			//	p_chain_ts->i_depth );
			if ( new_chain.i_depth )
				TSDate( p_mux, &new_chain,
				i_cut_dts - i_pcr_dts,
				i_pcr_dts );
			if ( p_chain_ts->i_depth )
				TSSchedule( p_mux,
				p_chain_ts, i_pcr_dts + i_pcr_length - i_cut_dts,
				i_cut_dts );
			return;
		}
	}

	if ( new_chain.i_depth )
		TSDate( p_mux, &new_chain, i_pcr_length, i_pcr_dts );
}

static int Open( mux_t *p_this, TsMuxParam_t* p_param )
{
	mux_t          *p_mux = p_this;
	mux_sys_t      *p_sys = NULL;
	//vlc_value_t         val;
	int i;

	//sout_CfgParse( p_mux, SOUT_CFG_PREFIX, ppsz_sout_options, p_mux->p_cfg );

	p_sys = (mux_sys_t*)malloc( sizeof( mux_sys_t ) );
	if( !p_sys )
		return 1;

	p_sys->i_pmtslots = p_sys->b_sdt = 0;
	p_sys->i_num_pmt = 1;
	p_sys->dvbpmt = NULL;
	memset( &p_sys->pmtmap, 0, sizeof(p_sys->pmtmap) );

	p_sys->csa_lock = new TLock();//vlc_mutex_init( &p_sys->csa_lock );

	//p_mux->pf_control   = Control;
	//p_mux->pf_addstream = AddStream;
	//p_mux->pf_delstream = DelStream;
	//p_mux->pf_mux       = Mux;
	//p_mux->p_sys        = p_sys;

	srand( (uint32_t)mdate() );

	for ( i = 0; i < MAX_PMT; i++ )
		p_sys->sdt_descriptors[i].psz_service_name
		= p_sys->sdt_descriptors[i].psz_provider = NULL;
	memset( p_sys->sdt_descriptors, 0, sizeof(sdt_desc_t) );

	p_sys->i_audio_bound = 0;
	p_sys->i_video_bound = 0;

	//var_Get( p_mux, SOUT_CFG_PREFIX "es-id-pid", &val );
	p_sys->b_es_id_pid = p_param->es_id_pid;//val.b_bool;

	//var_Get( p_mux, SOUT_CFG_PREFIX "muxpmt", &val );
	/*
	fetch string of pmts. Here's a sample: --sout-ts-muxpmt="0x451,0x200,0x28a,0x240,,0x450,0x201,0x28b,0x241,,0x452,0x202,0x28c,0x242"
	This would mean 0x451, 0x200, 0x28a, 0x240 would fall under one pmt (program), 0x450,0x201,0x28b,0x241 would fall under another
	*/
	if( p_param->muxpmt != NULL && *p_param->muxpmt ) //if( val.psz_string != NULL && *val.psz_string )
	{
		char *psz_next;
		char *psz = p_param->muxpmt;
		uint16_t i_pid;
		psz_next = psz;

		while( psz != NULL )
		{
			i_pid = (uint16_t)strtoul( psz, &psz_next, 0 );

			if ( strlen(psz_next) > 0 )
				psz = &psz_next[1];
			if ( i_pid == 0 )
			{
				p_sys->i_num_pmt++;
				if ( p_sys->i_num_pmt > MAX_PMT )
				{
					//msg_Err( p_mux,
					//	"Number of PMTs greater than compiled maximum (%d)", MAX_PMT );
					p_sys->i_num_pmt = MAX_PMT;
				}
			}
			else
			{
				p_sys->pmtmap[p_sys->i_pmtslots].i_pid = i_pid;
				p_sys->pmtmap[p_sys->i_pmtslots].i_prog = p_sys->i_num_pmt - 1;
				p_sys->i_pmtslots++;
				if ( p_sys->i_pmtslots > MAX_PMT_PID )
				{
					//msg_Err( p_mux,
					//	"Number of pids in PMT greater than compiled maximum (%d)",
					//	MAX_PMT_PID );
					p_sys->i_pmtslots = MAX_PMT_PID;
				}
			}

			/* Now sort according to pids for fast search later on */
			qsort( (void *)p_sys->pmtmap, p_sys->i_pmtslots,
				sizeof(pmt_map_t), &pmtcompare );
			if ( !*psz_next )
				psz = NULL;
		}
	}
	//if( val.psz_string != NULL) free( val.psz_string );

	p_sys->i_pat_version_number = rand() % 32;
	p_sys->pat.i_pid = 0;
	p_sys->pat.i_continuity_counter = 0;
	p_sys->pat.b_discontinuity = FALSE;

	//var_Get( p_mux, SOUT_CFG_PREFIX "tsid", &val );
	if ( p_param->tsid )//if ( val.i_int )
		p_sys->i_tsid = p_param->tsid;
	else
		p_sys->i_tsid = rand() % 65536;

	p_sys->i_netid = rand() % 65536;
//#ifdef HAVE_DVBPSI_SDT
	//var_Get( p_mux, SOUT_CFG_PREFIX "netid", &val );
	if ( p_param->netid )//if ( val.i_int )
		p_sys->i_netid = p_param->netid;
//#endif

	p_sys->i_pmt_version_number = rand() % 32;
	for( i = 0; i < p_sys->i_num_pmt; i++ )
	{
		p_sys->pmt[i].i_continuity_counter = 0;
		p_sys->pmt[i].b_discontinuity = FALSE;
	}

	p_sys->sdt.i_pid = 0x11;
	p_sys->sdt.i_continuity_counter = 0;
	p_sys->sdt.b_discontinuity = FALSE;

//#ifdef HAVE_DVBPSI_SDT
	//var_Get( p_mux, SOUT_CFG_PREFIX "sdtdesc", &val );
	p_sys->b_sdt = p_param->sdtdesc && *p_param->sdtdesc ? TRUE : FALSE;//p_sys->b_sdt = val.psz_string && *val.psz_string ? VLC_TRUE : FALSE;

	/* Syntax is provider_sdt1,service_name_sdt1,provider_sdt2,service_name_sdt2... */
	if( p_sys->b_sdt )
	{

		char *psz = p_param->sdtdesc;
		char *psz_sdttoken = psz;

		i = 0;
		while ( psz_sdttoken != NULL )
		{
			char *psz_end = strchr( psz_sdttoken, ',' );
			if( psz_end != NULL )
			{
				*psz_end++ = '\0';
			}
			if ( !(i % 2) )
			{
				p_sys->sdt_descriptors[i/2].psz_provider
					= _strdup(psz_sdttoken);
			}
			else
			{
				p_sys->sdt_descriptors[i/2].psz_service_name
					= _strdup(psz_sdttoken);
			}

			i++;
			psz_sdttoken = psz_end;
		}
	}
	//if( val.psz_string != NULL ) free( val.psz_string );
//#else
//	p_sys->b_sdt = FALSE;
//#endif

	//var_Get( p_mux, SOUT_CFG_PREFIX "alignment", &val );
	p_sys->b_data_alignment = p_param->alignment;//val.b_bool;

	//var_Get( p_mux, SOUT_CFG_PREFIX "program-pmt", &val );
	if( p_param->program_pmt && *p_param->program_pmt )//if( val.psz_string && *val.psz_string )
	{
		char *psz_next;
		char *psz = p_param->program_pmt;
		uint16_t i_pid;

		psz_next = psz;
		i = 0;
		while ( psz != NULL )
		{
			i_pid = (uint16_t)strtoul( psz, &psz_next, 0 );
			if( strlen(psz_next) > 0 )
				psz = &psz_next[1];
			else
				psz = NULL;

			if( i_pid == 0 )
			{
				//if( i > MAX_PMT )
				//	msg_Err( p_mux, "Number of PMTs > maximum (%d)",
				//	MAX_PMT );
			}
			else
			{
				p_sys->i_pmt_program_number[i] = i_pid;
				i++;
			}
		}
	}
	else
	{
		/* Option not specified, use 1, 2, 3... */
		for( i = 0; i < p_sys->i_num_pmt; i++ )
			p_sys->i_pmt_program_number[i] = i + 1;
	}
	//if( val.psz_string != NULL ) free( val.psz_string );

	//var_Get( p_mux, SOUT_CFG_PREFIX "pid-pmt", &val );
	if( p_param->pid_pmt )//if( val.i_int )
	{
		for( i = 0; i < p_sys->i_num_pmt; i++ )
			p_sys->pmt[i].i_pid = p_param->pid_pmt + i;//val.i_int + i; /* Does this make any sense? */
	}
	else
	{
		for( i = 0; i < p_sys->i_num_pmt; i++ )
			p_sys->pmt[i].i_pid = 0x42 + i;
	}

	p_sys->i_pid_free = p_sys->pmt[p_sys->i_num_pmt - 1].i_pid + 1;

	//var_Get( p_mux, SOUT_CFG_PREFIX "pid-video", &val );
	p_sys->i_pid_video = p_param->pid_video;//p_sys->i_pid_video = val.i_int;
	if ( p_sys->i_pid_video > p_sys->i_pid_free )
	{
		p_sys->i_pid_free = p_sys->i_pid_video + 1;
	}

	//var_Get( p_mux, SOUT_CFG_PREFIX "pid-audio", &val );
	p_sys->i_pid_audio = p_param->pid_audio;//p_sys->i_pid_audio = val.i_int;
	if ( p_sys->i_pid_audio > p_sys->i_pid_free )
	{
		p_sys->i_pid_free = p_sys->i_pid_audio + 1;
	}

	//var_Get( p_mux, SOUT_CFG_PREFIX "pid-spu", &val );
	p_sys->i_pid_spu = p_param->pid_spu;//p_sys->i_pid_spu = val.i_int;
	if ( p_sys->i_pid_spu > p_sys->i_pid_free )
	{
		p_sys->i_pid_free = p_sys->i_pid_spu + 1;
	}

	p_sys->i_pcr_pid = 0x1fff;
	p_sys->p_pcr_input = NULL;

	p_sys->i_mpeg4_streams = 0;

	p_sys->i_null_continuity_counter = 0;

	/* Allow to create constrained stream */
	//var_Get( p_mux, SOUT_CFG_PREFIX "bmin", &val );
	p_sys->i_bitrate_min = p_param->bmin;//p_sys->i_bitrate_min = val.i_int;

	//var_Get( p_mux, SOUT_CFG_PREFIX "bmax", &val );
	p_sys->i_bitrate_max = p_param->bmax;//p_sys->i_bitrate_max = val.i_int;

	if( p_sys->i_bitrate_min > 0 && p_sys->i_bitrate_max > 0 &&
		p_sys->i_bitrate_min > p_sys->i_bitrate_max )
	{
		//msg_Err( p_mux, "incompatible minimum and maximum bitrate, "
		//	"disabling bitrate control" );
		p_sys->i_bitrate_min = 0;
		p_sys->i_bitrate_max = 0;
	}
	if( p_sys->i_bitrate_min > 0 || p_sys->i_bitrate_max > 0 )
	{
		//msg_Err( p_mux, "bmin and bmax no more supported "
		//	"(if you need them report it)" );
	}

	//var_Get( p_mux, SOUT_CFG_PREFIX "shaping", &val );
	p_sys->i_shaping_delay = (int64_t)p_param->shaping * 1000;//(int64_t)val.i_int * 1000;
	if( p_sys->i_shaping_delay <= 0 )
	{
		//msg_Err( p_mux,
		//	"invalid shaping ("I64Fd"ms) resetting to 200ms",
		//	p_sys->i_shaping_delay / 1000 );
		p_sys->i_shaping_delay = 200000;
	}

	//var_Get( p_mux, SOUT_CFG_PREFIX "pcr", &val );
	p_sys->i_pcr_delay = (int64_t)p_param->pcr * 1000;//(int64_t)val.i_int * 1000;
	if( p_sys->i_pcr_delay <= 0 ||
		p_sys->i_pcr_delay >= p_sys->i_shaping_delay )
	{
		//msg_Err( p_mux,
		//	"invalid pcr delay ("I64Fd"ms) resetting to 70ms",
		//	p_sys->i_pcr_delay / 1000 );
		p_sys->i_pcr_delay = 70000;
	}

	//var_Get( p_mux, SOUT_CFG_PREFIX "dts-delay", &val );
	p_sys->i_dts_delay = (int64_t)p_param->dts_delay * 1000;//(int64_t)val.i_int * 1000;

	//msg_Dbg( p_mux, "shaping="I64Fd" pcr="I64Fd" dts_delay="I64Fd,
	//	p_sys->i_shaping_delay, p_sys->i_pcr_delay, p_sys->i_dts_delay );

	//var_Get( p_mux, SOUT_CFG_PREFIX "use-key-frames", &val );
	p_sys->b_use_key_frames = p_param->use_key_frames;//val.b_bool;

	/* for TS generation */
	p_sys->i_pcr    = 0;

	p_sys->csa      = NULL;
	//var_Get( p_mux, SOUT_CFG_PREFIX "csa-ck", &val );
	if( p_param->csa_ck && *p_param->csa_ck )//if( val.psz_string && *val.psz_string )
	{
		char *psz = p_param->csa_ck;

		/* skip 0x */
		if( psz[0] == '0' && ( psz[1] == 'x' || psz[1] == 'X' ) )
		{
			psz += 2;
		}
		if( strlen( psz ) != 16 )
		{
			//msg_Dbg( p_mux, "invalid csa ck (it must be 16 chars long)" );
		}
		else
		{
			uint64_t i_ck; scanf(psz, "%I64x", &i_ck); //uint64_t i_ck = strtoull( psz, NULL, 16 );
			uint8_t  ck[8];
			int      i;

			for( i = 0; i < 8; i++ )
			{
				ck[i] = ( i_ck >> ( 56 - 8*i) )&0xff;
			}
//#ifndef TS_NO_CSA_CK_MSG
			//msg_Dbg( p_mux, "using CSA scrambling with ck=%x:%x:%x:%x:%x:%x:%x:%x",
			//	ck[0], ck[1], ck[2], ck[3], ck[4], ck[5], ck[6], ck[7] );
//#endif
			p_sys->csa = csa_New();
			if( p_sys->csa )
			{
				//vlc_value_t pkt_val;

				csa_SetCW( p_sys->csa, ck, ck );

				//var_Get( p_mux, SOUT_CFG_PREFIX "csa-pkt", &pkt_val );
				if( p_param->csa_pkt < 12 || p_param->csa_pkt > 188 )//if( pkt_val.i_int < 12 || pkt_val.i_int > 188 )
				{
					//msg_Err( p_mux, "wrong packet size %d specified.", pkt_val.i_int );
					//msg_Warn( p_mux, "using default packet size of 188 bytes" );
					p_sys->i_csa_pkt_size = 188;
				}
				else p_sys->i_csa_pkt_size = p_param->csa_pkt;//pkt_val.i_int;
				//msg_Dbg( p_mux, "encrypting %d bytes of packet", p_sys->i_csa_pkt_size );
			}
		}
	}
	//if( val.psz_string ) free( val.psz_string );

	//var_Get( p_mux, SOUT_CFG_PREFIX "crypt-audio", &val );
	p_sys->b_crypt_audio = p_param->crypt_audio;//val.b_bool;

	//var_Get( p_mux, SOUT_CFG_PREFIX "crypt-video", &val );
	p_sys->b_crypt_video = p_param->crypt_video;//val.b_bool;

	//end add by chenrui
	p_sys->p_param = p_param;
	p_mux->p_sys = p_sys;

	return 0;
}

static void Close( mux_t *p_this )
{
	mux_t          *p_mux = p_this;
	mux_sys_t      *p_sys = p_mux->p_sys;
	int i;

	p_sys->csa_lock->Lock();//vlc_mutex_lock( &p_sys->csa_lock );
	if( p_sys->csa )
	{
		//var_DelCallback( p_mux, SOUT_CFG_PREFIX "csa-ck", ChangeKeyCallback, NULL );
		//var_DelCallback( p_mux, SOUT_CFG_PREFIX "csa2-ck", ChangeKeyCallback, NULL );
		//var_DelCallback( p_mux, SOUT_CFG_PREFIX "csa-use", ActiveKeyCallback, NULL );
		csa_Delete( p_sys->csa );
		p_sys->csa = NULL;
	}
	p_sys->csa_lock->UnLock();//vlc_mutex_unlock( &p_sys->csa_lock );

	for( i = 0; i < MAX_PMT; i++ )
	{
		if( p_sys->sdt_descriptors[i].psz_service_name != NULL )
			free( p_sys->sdt_descriptors[i].psz_service_name );
		if( p_sys->sdt_descriptors[i].psz_provider != NULL )
			free( p_sys->sdt_descriptors[i].psz_provider );
	}

	delete p_sys->csa_lock;	//vlc_mutex_destroy( &p_sys->csa_lock );
	free( p_sys->dvbpmt );
	free( p_sys );
}

static int Mux( mux_t *p_mux )
{
	mux_sys_t  *p_sys = p_mux->p_sys;
	ts_stream_t *p_pcr_stream;

	if( p_sys->i_pcr_pid == 0x1fff )
	{
		int i;
		for( i = 0; i < p_mux->i_nb_inputs; i++ )
		{
			p_mux->pp_inputs[i]->p_fifo->FreeBuffer();//block_FifoEmpty( p_mux->pp_inputs[i]->p_fifo );
		}
		printf("waiting for PCR streams.\n");//msg_Dbg( p_mux, "waiting for PCR streams" );
		//msleep( 1000 );
		return 0;
	}

	p_pcr_stream = (ts_stream_t*)p_sys->p_pcr_input->p_sys;

	for( ;; )
	{
		buffer_chain_t		chain_ts;
		int                 i_packet_count;
		int                 i_packet_pos;
		mtime_t             i_pcr_dts;
		mtime_t             i_pcr_length;
		mtime_t             i_shaping_delay;
		int i;

		if( p_pcr_stream->b_key_frame )
		{
			i_shaping_delay = p_pcr_stream->i_pes_length;
		}
		else
		{
			i_shaping_delay = p_sys->i_shaping_delay;
		}

		/* 1: get enough PES packet for all input */
		//for( ;; )
		{
			bool_t b_ok = TRUE;
			block_t *p_data;

			/* Accumulate enough data in the pcr stream (>i_shaping_delay) */
			/* Accumulate enough data in all other stream ( >= length of pcr)*/
			for( i = -1; i < p_mux->i_nb_inputs; i++ )
			{
				input_t *p_input;
				ts_stream_t *p_stream;
				int64_t i_spu_delay = 0;

				if( i == -1 )
					p_input = p_sys->p_pcr_input;
				else if( p_mux->pp_inputs[i]->p_sys == p_pcr_stream )
					continue;
				else
					p_input = p_mux->pp_inputs[i];
				p_stream = (ts_stream_t*)p_input->p_sys;

				if( ( p_stream == p_pcr_stream &&
					p_stream->i_pes_length < i_shaping_delay ) ||
					p_stream->i_pes_dts + p_stream->i_pes_length <
					p_pcr_stream->i_pes_dts + p_pcr_stream->i_pes_length )
				{
					/* Need more data */
					if( p_input->p_fifo->GetFullBufferCount()/*i_depth*/ <= 1 )
					{
						if( p_input->p_fmt->i_cat == AUDIO_ES ||
							p_input->p_fmt->i_cat == VIDEO_ES )
						{
							/* We need more data */
							return 0;//return VLC_SUCCESS;
						}
						else if( p_input->p_fifo->GetFullBufferCount()/*i_depth*/ <= 0 )
						{
							/* spu, only one packet is needed */
							continue;
						}
						else
						{
							/* Don't mux the SPU yet if it is too early */
							block_t *p_spu = (block_t *)p_input->p_fifo->GetFullBufferShadow();//block_FifoShow( p_input->p_fifo );

							i_spu_delay =
								p_spu->i_dts - p_pcr_stream->i_pes_dts;

							if( i_spu_delay > i_shaping_delay &&
								i_spu_delay < INT64_C(100000000) )
								continue;

							if ( i_spu_delay >= INT64_C(100000000)
								|| i_spu_delay < 10000 )
							{
								BufferChainClean(&p_stream->chain_pes);
								p_stream->i_pes_dts = 0;
								p_stream->i_pes_used = 0;
								p_stream->i_pes_length = 0;
								continue;
							}
						}
					}
					b_ok = FALSE;

					if( p_stream == p_pcr_stream || p_sys->b_data_alignment
						|| p_input->p_fmt->i_codec !=
						FOURCC('m', 'p', 'g', 'a') )
					{
						p_data = (block_t *)p_input->p_fifo->GetFullBuffer();//block_FifoGet( p_input->p_fifo );
						
						if( p_input->p_fmt->i_codec ==
							FOURCC('m', 'p', '4', 'a' ) )
							p_data = Add_ADTS( p_data, p_input->p_fmt );
					}
					else
						p_data = FixPES( p_mux, p_input->p_fifo );

					if( p_input->p_fifo->GetFullBufferCount()/*i_depth*/ > 0 &&
						p_input->p_fmt->i_cat != SPU_ES )
					{
						block_t *p_next = (block_t *)p_input->p_fifo->GetFullBufferShadow();//block_FifoShow( p_input->p_fifo );
						p_data->i_length = p_next->i_dts - p_data->i_dts;
					}
					else if( p_input->p_fmt->i_codec !=
						FOURCC('s', 'u', 'b', 't' ) )
						p_data->i_length = 1000;

					if( ( p_pcr_stream->i_pes_dts > 0 &&
						p_data->i_dts - 10000000 > p_pcr_stream->i_pes_dts +
						p_pcr_stream->i_pes_length ) ||
						p_data->i_dts < p_stream->i_pes_dts ||
						( p_stream->i_pes_dts > 0 &&
						p_input->p_fmt->i_cat != SPU_ES &&
						p_data->i_dts - 10000000 > p_stream->i_pes_dts +
						p_stream->i_pes_length ) )
					{
						printf("packet with too strange dts "
							"(dts=%I64d,old=%I64d,pcr=%I64d)\n",
							p_data->i_dts, p_stream->i_pes_dts,
							p_pcr_stream->i_pes_dts);
						//msg_Warn( p_mux, "packet with too strange dts "
						//	"(dts="I64Fd",old="I64Fd",pcr="I64Fd")",
						//	p_data->i_dts, p_stream->i_pes_dts,
						//	p_pcr_stream->i_pes_dts );
						delete p_data;//block_Release( p_data );

						BufferChainClean( /*p_mux->p_sout,*/
							&p_stream->chain_pes );
						p_stream->i_pes_dts = 0;
						p_stream->i_pes_used = 0;
						p_stream->i_pes_length = 0;

						if( p_input->p_fmt->i_cat != SPU_ES )
						{
							BufferChainClean( /*p_mux->p_sout,*/
								&p_pcr_stream->chain_pes );
							p_pcr_stream->i_pes_dts = 0;
							p_pcr_stream->i_pes_used = 0;
							p_pcr_stream->i_pes_length = 0;
						}
					}
					else
					{
						int i_header_size = 0;
						int b_data_alignment = 0;
						if( p_input->p_fmt->i_cat == SPU_ES )
						{
							if( p_input->p_fmt->i_codec ==
								FOURCC('s','u','b','t') )
							{
								/* Prepend header */
								Buffer buffer_temp;
								buffer_temp.FillData( p_data->m_pData, p_data->m_nDataSize );
								p_data->ExtendBuffer( 2 + p_data->m_nDataSize );
								p_data->m_nDataSize += 2;
								p_data->AppendData(buffer_temp.m_pData, buffer_temp.m_nDataSize);
								//p_data = block_Realloc( p_data, 2,
								//	p_data->i_buffer );
								p_data->m_pData/*p_buffer*/[0] =
									( (p_data->m_nDataSize/*i_buffer*/ - 2) >> 8) & 0xff;
								p_data->m_pData/*p_buffer*/[1] =
									( (p_data->m_nDataSize/*i_buffer*/ - 2)     ) & 0xff;

								/* remove trailling \0 if any */
								if( p_data->m_nDataSize/*i_buffer*/ > 2 &&
									p_data->m_pData/*p_buffer*/[p_data->m_nDataSize/*i_buffer*/ -1] ==
									'\0' )
									p_data->m_nDataSize/*i_buffer*/--;

								/* Append a empty sub (sub text only) */
								if( p_data->m_nDataSize/*i_length*/ > 0 &&
									!( p_data->m_nDataSize/*i_buffer*/ == 1 &&
									*p_data->m_pData/*p_buffer*/ == ' ' ) )
								{
									block_t *p_spu = new block_t();p_spu->AllocateBuffer(3);//block_New( p_mux, 3 );

									p_spu->i_dts = p_spu->i_pts =
										p_data->i_dts + p_data->i_length;
									p_spu->i_length = 1000;

									p_spu->m_pData/*p_buffer*/[0] = 0;
									p_spu->m_pData/*p_buffer*/[1] = 1;
									p_spu->m_pData/*p_buffer*/[2] = ' ';

									EStoPES( &p_spu, p_spu,
										p_input->p_fmt,
										p_stream->i_stream_id, 1,
										0, 0, 0 );
									p_data->p_next = p_spu;
								}
							}
							else if( p_input->p_fmt->i_codec ==
								FOURCC('t','e','l','x') )
							{
								/* EN 300 472 */
								i_header_size = 0x24;
								b_data_alignment = 1;
							}
							else if( p_input->p_fmt->i_codec ==
								FOURCC('d','v','b','s') )
							{
								/* EN 300 743 */
								b_data_alignment = 1;
							}
						}
						else if( p_data->i_length < 0 ||
							p_data->i_length > 2000000 )
						{
							/* FIXME choose a better value, but anyway we
							* should never have to do that */
							p_data->i_length = 1000;
						}

						p_stream->i_pes_length += p_data->i_length;
						if( p_stream->i_pes_dts == 0 )
						{
							p_stream->i_pes_dts = p_data->i_dts;
						}

						/* Convert to pes */
						if( p_stream->i_stream_id == 0xa0 &&
							p_data->i_pts <= 0 )
						{
							/* XXX yes I know, it's awfull, but it's needed,
							* so don't remove it ... */
							p_data->i_pts = p_data->i_dts;
						}

						EStoPES ( /*p_mux->p_sout,*/ &p_data, p_data,
							p_input->p_fmt, p_stream->i_stream_id,
							1, b_data_alignment, i_header_size, 0 );

						BufferChainAppend( &p_stream->chain_pes, p_data );

						if( p_sys->b_use_key_frames && p_stream == p_pcr_stream
							&& (p_data->i_flags & BLOCK_FLAG_TYPE_I)
							&& !(p_data->i_flags & BLOCK_FLAG_NO_KEYFRAME)
							&& (p_stream->i_pes_length > 400000) )
						{
							i_shaping_delay = p_stream->i_pes_length;
							p_stream->b_key_frame = 1;
						}
					}
				}
			}

			if( !b_ok)
			{
				break;
			}
		}

		/* save */
		i_pcr_dts      = p_pcr_stream->i_pes_dts;
		i_pcr_length   = p_pcr_stream->i_pes_length;
		p_pcr_stream->b_key_frame = 0;

		/* msg_Dbg( p_mux, "starting muxing %lldms", i_pcr_length / 1000 ); */

		/* 2: calculate non accurate total size of muxed ts */
		i_packet_count = 0;
		for( i = 0; i < p_mux->i_nb_inputs; i++ )
		{
			ts_stream_t *p_stream = p_mux->pp_inputs[i]->p_sys;
			block_t		*p_pes;

			/* False for pcr stream but it will be enough to do PCR algo */
			for( p_pes = p_stream->chain_pes.p_first; p_pes != NULL;
				p_pes = p_pes->p_next )
			{
				int i_size = p_pes->m_nDataSize/*i_buffer*/;
				if( p_pes->i_dts + p_pes->i_length >
					p_pcr_stream->i_pes_dts + p_pcr_stream->i_pes_length )
				{
					mtime_t i_frag = p_pcr_stream->i_pes_dts +
						p_pcr_stream->i_pes_length - p_pes->i_dts;
					if( i_frag < 0 )
					{
						/* Next stream */
						break;
					}
					i_size = (int)(p_pes->m_nDataSize/*i_buffer*/ * i_frag / p_pes->i_length);
				}
				i_packet_count += ( i_size + 183 ) / 184;
			}
		}
		/* add overhead for PCR (not really exact) */
		i_packet_count += (int)((8 * i_pcr_length / p_sys->i_pcr_delay + 175) / 176);

		/* 3: mux PES into TS */
		BufferChainInit( &chain_ts );
		/* append PAT/PMT  -> FIXME with big pcr delay it won't have enough pat/pmt */
		GetPAT( p_mux, &chain_ts );
		GetPMT( p_mux, &chain_ts );
		i_packet_pos = 0;
		i_packet_count += chain_ts.i_depth;
		/* msg_Dbg( p_mux, "estimated pck=%d", i_packet_count ); */

		for( ;; )
		{
			int         i_stream;
			mtime_t     i_dts;
			ts_stream_t *p_stream;
			input_t		*p_input;	//sout_input_t *p_input;
			block_t		*p_ts;
			bool_t		b_pcr;

			/* Select stream (lowest dts) */
			for( i = 0, i_stream = -1, i_dts = 0; i < p_mux->i_nb_inputs; i++ )
			{
				p_stream = (ts_stream_t*)p_mux->pp_inputs[i]->p_sys;

				if( p_stream->i_pes_dts == 0 )
				{
					continue;
				}

				if( i_stream == -1 ||
					p_stream->i_pes_dts < i_dts )
				{
					i_stream = i;
					i_dts = p_stream->i_pes_dts;
				}
			}
			if( i_stream == -1 || i_dts > i_pcr_dts + i_pcr_length )
			{
				break;
			}
			p_stream = (ts_stream_t*)p_mux->pp_inputs[i_stream]->p_sys;
			p_input = p_mux->pp_inputs[i_stream];

			/* do we need to issue pcr */
			b_pcr = FALSE;
			if( p_stream == p_pcr_stream &&
				i_pcr_dts + i_packet_pos * i_pcr_length / i_packet_count >=
				p_sys->i_pcr + p_sys->i_pcr_delay )
			{
				b_pcr = TRUE;
				p_sys->i_pcr = i_pcr_dts + i_packet_pos *
					i_pcr_length / i_packet_count;
			}

			/* Build the TS packet */
			p_ts = TSNew( p_mux, p_stream, b_pcr );

			if( p_sys->csa != NULL &&
				(p_input->p_fmt->i_cat != AUDIO_ES || p_sys->b_crypt_audio) &&
				(p_input->p_fmt->i_cat != VIDEO_ES || p_sys->b_crypt_video) )
			{
				p_ts->i_flags |= BLOCK_FLAG_SCRAMBLED;
			}
			i_packet_pos++;

			/* */
			BufferChainAppend( &chain_ts, p_ts );
		}

		/* 4: date and send */
		TSSchedule( p_mux, &chain_ts, i_pcr_length, i_pcr_dts );
	}
	return 0;
}


static int AddStream( mux_t *p_mux, input_t *p_input )
{
	mux_sys_t			*p_sys = p_mux->p_sys;
	ts_stream_t         *p_stream;
	int                  i;

	p_input->p_sys = p_stream = (ts_stream_t *)malloc( sizeof( ts_stream_t ) );
	if( !p_input->p_sys )
		return -1;

	/* Init this new stream */
	if ( p_sys->b_es_id_pid )
		p_stream->i_pid = p_input->p_fmt->i_id & 0x1fff;
	else
		p_stream->i_pid = AllocatePID( p_sys, p_input->p_fmt->i_cat );
	p_stream->i_codec = p_input->p_fmt->i_codec;
	p_stream->i_continuity_counter    = 0;
	p_stream->b_discontinuity         = false;
	p_stream->i_decoder_specific_info = 0;
	p_stream->p_decoder_specific_info = NULL;

	//msg_Dbg( p_mux, "adding input codec=%4.4s pid=%d",
	//	(char*)&p_input->p_fmt->i_codec, p_stream->i_pid );

	/* All others fields depand on codec */
	switch( p_input->p_fmt->i_cat )
	{
	case VIDEO_ES:
		switch( p_input->p_fmt->i_codec )
		{
		case FOURCC( 'm', 'p','g', 'v' ):
			/* TODO: do we need to check MPEG-I/II ? */
			p_stream->i_stream_type = 0x02;
			p_stream->i_stream_id = 0xe0;
			break;
		case FOURCC( 'm', 'p','4', 'v' ):
			p_stream->i_stream_type = 0x10;
			p_stream->i_stream_id = 0xe0;
			p_stream->i_es_id = p_stream->i_pid;
			break;
		case FOURCC( 'h', '2','6', '4' ):
			p_stream->i_stream_type = 0x1b;
			p_stream->i_stream_id = 0xe0;
			break;
			/* XXX dirty dirty but somebody want that:
			*     using crapy MS-codec XXX */
			/* I didn't want to do that :P */
		case FOURCC( 'H', '2', '6', '3' ):
		case FOURCC( 'I', '2', '6', '3' ):
		case FOURCC( 'W', 'M', 'V', '3' ):
		case FOURCC( 'W', 'M', 'V', '2' ):
		case FOURCC( 'W', 'M', 'V', '1' ):
		case FOURCC( 'D', 'I', 'V', '3' ):
		case FOURCC( 'D', 'I', 'V', '2' ):
		case FOURCC( 'D', 'I', 'V', '1' ):
		case FOURCC( 'M', 'J', 'P', 'G' ):
			p_stream->i_stream_type = 0xa0; /* private */
			p_stream->i_stream_id = 0xa0;   /* beurk */
			p_stream->i_bih_codec  = p_input->p_fmt->i_codec;
			p_stream->i_bih_width  = p_input->p_fmt->video.i_width;
			p_stream->i_bih_height = p_input->p_fmt->video.i_height;
			break;
		default:
			free( p_stream );
			return -666;
		}
		p_sys->i_video_bound++;
		break;

	case AUDIO_ES:
		switch( p_input->p_fmt->i_codec )
		{
		case FOURCC( 'm', 'p','g', 'a' ):
		case FOURCC( 'm', 'p', '3', ' ' ):
			p_stream->i_stream_type =
				p_input->p_fmt->audio.i_rate >= 32000 ? 0x03 : 0x04;
			p_stream->i_stream_id = 0xc0;
			break;
		case FOURCC( 'a', '5','2', ' ' ):
			p_stream->i_stream_type = 0x81;
			p_stream->i_stream_id = 0xbd;
			break;
		case FOURCC( 'l', 'p','c', 'm' ):
			p_stream->i_stream_type = 0x83;
			p_stream->i_stream_id = 0xbd;
			break;
		case FOURCC( 'd', 't','s', ' ' ):
			p_stream->i_stream_type = 0x06;
			p_stream->i_stream_id = 0xbd;
			break;
		case FOURCC( 'm', 'p','4', 'a' ):
			/* XXX: make that configurable in some way when LOAS
			* is implemented for AAC in TS */
			//p_stream->i_stream_type = 0x11; /* LOAS/LATM */
			p_stream->i_stream_type = 0x0f; /* ADTS */
			p_stream->i_stream_id = 0xfa;
			p_sys->i_mpeg4_streams++;
			p_stream->i_es_id = p_stream->i_pid;
			break;
		default:
			free( p_stream );
			return -666;
		}
		p_sys->i_audio_bound++;
		break;

	case SPU_ES:
		switch( p_input->p_fmt->i_codec )
		{
		case FOURCC( 's', 'p','u', ' ' ):
			p_stream->i_stream_type = 0x82;
			p_stream->i_stream_id = 0xbd;
			break;
		case FOURCC( 's', 'u','b', 't' ):
			p_stream->i_stream_type = 0x12;
			p_stream->i_stream_id = 0xfa;
			p_sys->i_mpeg4_streams++;
			p_stream->i_es_id = p_stream->i_pid;
			break;
		case FOURCC('d','v','b','s'):
			p_stream->i_stream_type = 0x06;
			p_stream->i_es_id = p_input->p_fmt->subs.dvb.i_id;
			p_stream->i_stream_id = 0xbd;
			break;
		case FOURCC('t','e','l','x'):
			p_stream->i_stream_type = 0x06;
			p_stream->i_stream_id = 0xbd; /* FIXME */
			break;
		default:
			free( p_stream );
			return -666;
		}
		break;

	default:
		free( p_stream );
		return -666;
	}

	p_stream->i_langs = 1+p_input->p_fmt->i_extra_languages;
	p_stream->lang = (uint8_t *) malloc(p_stream->i_langs*3);
	if( !p_stream->lang )
	{
		p_stream->i_langs = 0;
		free( p_stream );
		return -1;
	}
	i = 1;
	p_stream->lang[0] =
		p_stream->lang[1] =
		p_stream->lang[2] = '\0';
	if( p_input->p_fmt->psz_language )
	{
		char *psz = p_input->p_fmt->psz_language;
		const iso639_lang_t *pl = NULL;

		if( strlen( psz ) == 2 )
		{
			pl = GetLang_1( psz );
		}
		else if( strlen( psz ) == 3 )
		{
			pl = GetLang_2B( psz );
			if( !strcmp( pl->psz_iso639_1, "??" ) )
			{
				pl = GetLang_2T( psz );
			}
		}
		if( pl && strcmp( pl->psz_iso639_1, "??" ) )
		{
			p_stream->lang[0] = pl->psz_iso639_2T[0];
			p_stream->lang[1] = pl->psz_iso639_2T[1];
			p_stream->lang[2] = pl->psz_iso639_2T[2];

			//msg_Dbg( p_mux, "    - lang=%c%c%c",
			//	p_stream->lang[0], p_stream->lang[1],
			//	p_stream->lang[2] );
		}
	}
	while( i < p_stream->i_langs ) {
		if( p_input->p_fmt->p_extra_languages[i-1].psz_language )
		{
			char *psz = p_input->p_fmt->p_extra_languages[i-1].psz_language;
			const iso639_lang_t *pl = NULL;

			if( strlen( psz ) == 2 )
			{
				pl = GetLang_1( psz );
			}
			else if( strlen( psz ) == 3 )
			{
				pl = GetLang_2B( psz );
				if( !strcmp( pl->psz_iso639_1, "??" ) )
				{
					pl = GetLang_2T( psz );
				}
			}
			if( pl && strcmp( pl->psz_iso639_1, "??" ) )
			{
				p_stream->lang[i*3+0] = pl->psz_iso639_2T[0];
				p_stream->lang[i*3+1] = pl->psz_iso639_2T[1];
				p_stream->lang[i*3+2] = pl->psz_iso639_2T[2];

				//msg_Dbg( p_mux, "    - lang=%c%c%c",
				//	p_stream->lang[i*3+0], p_stream->lang[i*3+1],
				//	p_stream->lang[i*3+2] );
			}
		}
		i++;
	}

	/* Create decoder specific info for subt */
	if( p_stream->i_codec == FOURCC( 's', 'u','b', 't' ) )
	{
		uint8_t *p;

		p_stream->i_decoder_specific_info = 55;
		p_stream->p_decoder_specific_info = p = (uint8_t *)
			malloc( p_stream->i_decoder_specific_info );
		if( p )
		{
			p[0] = 0x10;    /* textFormat, 0x10 for 3GPP TS 26.245 */
			p[1] = 0x00;    /* flags: 1b: associated video info flag
							3b: reserved
							1b: duration flag
							3b: reserved */
			p[2] = 52;      /* remaining size */

			p += 3;

			p[0] = p[1] = p[2] = p[3] = 0; p+=4;    /* display flags */
			*p++ = 0;  /* horizontal justification (-1: left, 0 center, 1 right) */
			*p++ = 1;  /* vertical   justification (-1: top, 0 center, 1 bottom) */

			p[0] = p[1] = p[2] = 0x00; p+=3;/* background rgb */
			*p++ = 0xff;                    /* background a */

			p[0] = p[1] = 0; p += 2;        /* text box top */
			p[0] = p[1] = 0; p += 2;        /* text box left */
			p[0] = p[1] = 0; p += 2;        /* text box bottom */
			p[0] = p[1] = 0; p += 2;        /* text box right */

			p[0] = p[1] = 0; p += 2;        /* start char */
			p[0] = p[1] = 0; p += 2;        /* end char */
			p[0] = p[1] = 0; p += 2;        /* default font id */

			*p++ = 0;                       /* font style flags */
			*p++ = 12;                      /* font size */

			p[0] = p[1] = p[2] = 0x00; p+=3;/* foreground rgb */
			*p++ = 0x00;                    /* foreground a */

			p[0] = p[1] = p[2] = 0; p[3] = 22; p += 4;
			memcpy( p, "ftab", 4 ); p += 4;
			*p++ = 0; *p++ = 1;             /* entry count */
			p[0] = p[1] = 0; p += 2;        /* font id */
			*p++ = 9;                       /* font name length */
			memcpy( p, "Helvetica", 9 );    /* font name */
		}
		else p_stream->i_decoder_specific_info = 0;
	}
	else
	{
		/* Copy extra data (VOL for MPEG-4 and extra BitMapInfoHeader for VFW */
		p_stream->i_decoder_specific_info = p_input->p_fmt->i_extra;
		if( p_stream->i_decoder_specific_info > 0 )
		{
			p_stream->p_decoder_specific_info = (uint8_t *)
				malloc( p_stream->i_decoder_specific_info );
			if( p_stream->p_decoder_specific_info )
			{
				memcpy( p_stream->p_decoder_specific_info,
					p_input->p_fmt->p_extra,
					p_input->p_fmt->i_extra );
			}
			else p_stream->i_decoder_specific_info = 0;
		}
	}

	/* Init pes chain */
	BufferChainInit( &p_stream->chain_pes );
	p_stream->i_pes_dts    = 0;
	p_stream->i_pes_length = 0;
	p_stream->i_pes_used   = 0;
	p_stream->b_key_frame  = 0;

	/* We only change PMT version (PAT isn't changed) */
	p_sys->i_pmt_version_number = ( p_sys->i_pmt_version_number + 1 )%32;

	/* Update pcr_pid */
	if( p_input->p_fmt->i_cat != SPU_ES &&
		( p_sys->i_pcr_pid == 0x1fff || p_input->p_fmt->i_cat == VIDEO_ES ) )
	{
		if( p_sys->p_pcr_input )
		{
			/* There was already a PCR stream, so clean context */
			/* FIXME */
		}
		p_sys->i_pcr_pid   = p_stream->i_pid;
		p_sys->p_pcr_input = p_input;

		//msg_Dbg( p_mux, "new PCR PID is %d", p_sys->i_pcr_pid );
	}

	return 0;
}

static int DelStream( mux_t *p_mux, input_t *p_input )
{
	mux_sys_t  *p_sys = p_mux->p_sys;
	ts_stream_t     *p_stream;
	//vlc_value_t     val;

	p_stream = (ts_stream_t*)p_input->p_sys;
	//msg_Dbg( p_mux, "removing input pid=%d", p_stream->i_pid );

	if( p_sys->i_pcr_pid == p_stream->i_pid )
	{
		int i;

		/* Find a new pcr stream (Prefer Video Stream) */
		p_sys->i_pcr_pid = 0x1fff;
		p_sys->p_pcr_input = NULL;
		for( i = 0; i < p_mux->i_nb_inputs; i++ )
		{
			if( p_mux->pp_inputs[i] == p_input )
			{
				continue;
			}

			if( p_mux->pp_inputs[i]->p_fmt->i_cat == VIDEO_ES )
			{
				p_sys->i_pcr_pid  =
					((ts_stream_t*)p_mux->pp_inputs[i]->p_sys)->i_pid;
				p_sys->p_pcr_input= p_mux->pp_inputs[i];
				break;
			}
			else if( p_mux->pp_inputs[i]->p_fmt->i_cat != SPU_ES &&
				p_sys->i_pcr_pid == 0x1fff )
			{
				p_sys->i_pcr_pid  =
					((ts_stream_t*)p_mux->pp_inputs[i]->p_sys)->i_pid;
				p_sys->p_pcr_input= p_mux->pp_inputs[i];
			}
		}
		if( p_sys->p_pcr_input )
		{
			/* Empty TS buffer */
			/* FIXME */
		}
		//msg_Dbg( p_mux, "new PCR PID is %d", p_sys->i_pcr_pid );
	}

	/* Empty all data in chain_pes */
	BufferChainClean( &p_stream->chain_pes );

	free(p_stream->lang);
	free( p_stream->p_decoder_specific_info );
	if( p_stream->i_stream_id == 0xfa ||
		p_stream->i_stream_id == 0xfb ||
		p_stream->i_stream_id == 0xfe )
	{
		p_sys->i_mpeg4_streams--;
	}

	//var_Get( p_mux, SOUT_CFG_PREFIX "pid-video", &val );
	if( p_sys->p_param->pid_video/*val.i_int*/ > 0 )
	{
		int i_pid_video = p_sys->p_param->pid_video/*val.i_int*/;
		if ( i_pid_video == p_stream->i_pid )
		{
			p_sys->i_pid_video = i_pid_video;
			//msg_Dbg( p_mux, "freeing video PID %d", i_pid_video );
		}
	}

	//var_Get( p_mux, SOUT_CFG_PREFIX "pid-audio", &val );
	if( p_sys->p_param->pid_audio/*val.i_int*/ > 0 )
	{
		int i_pid_audio = p_sys->p_param->pid_audio/*val.i_int*/;
		if ( i_pid_audio == p_stream->i_pid )
		{
			p_sys->i_pid_audio = i_pid_audio;
			//msg_Dbg( p_mux, "freeing audio PID %d", i_pid_audio );
		}
	}
	//var_Get( p_mux, SOUT_CFG_PREFIX "pid-spu", &val );
	if( p_sys->p_param->pid_spu/*val.i_int*/ > 0 )
	{
		int i_pid_spu = p_sys->p_param->pid_spu/*val.i_int*/;
		if ( i_pid_spu == p_stream->i_pid )
		{
			p_sys->i_pid_spu = i_pid_spu;
			//msg_Dbg( p_mux, "freeing spu PID %d", i_pid_spu );
		}
	}
	free( p_stream );

	/* We only change PMT version (PAT isn't changed) */
	p_sys->i_pmt_version_number++; p_sys->i_pmt_version_number %= 32;

	return 0/*VLC_SUCCESS*/;
}

//--------------------------------------------------------------------
//class TsMux
//--------------------------------------------------------------------

TsMux::TsMux()
{
	m_pMux = NULL;
	m_hThread = NULL;
	m_eThreadStop = NULL;
}

TsMux::~TsMux()
{
	Close();
}

int	TsMux::Open(TsMuxParam_t* p_param, GetTsDataCBFun pGetTsDataCBFun, PVOID pUserData)
{
	if (m_pMux)
		return -1;

	m_pMux = new mux_t();

	m_pMux->p_access = pGetTsDataCBFun;
	m_pMux->p_access_user_data = pUserData;

	if ( ::Open( m_pMux, p_param) != 0)
	{
		delete m_pMux;
		return -2;
	}

	return 0;
}

void TsMux::Close()
{
	if (!m_pMux)
		return;

	::Close(m_pMux);

	for (int i = 0; i < m_pMux->i_nb_inputs; i++)
	{
		delete m_pMux->pp_inputs[i]->p_fifo;
		delete m_pMux->pp_inputs[i];
		m_pMux->pp_inputs[i] = NULL;
	}
	m_pMux->i_nb_inputs = 0;

	delete m_pMux;
	m_pMux = NULL;
}

int TsMux::AddStream(HANDLE * pHandle, es_format_t *p_fmt)
{
	if (!m_pMux)
		return -1;

	input_t * pInput = new input_t();
	if (!pInput)
		return -2;
	pInput->p_fifo = new block_fifo_t();
	if (!pInput->p_fifo)
		return -1;

	pInput->p_fmt = p_fmt;

	if ( ::AddStream( m_pMux, pInput ) != 0)
	{
		delete pInput->p_fifo;
		delete pInput;
		return -3;
	}

	m_pMux->pp_inputs[m_pMux->i_nb_inputs++] = pInput;

	*pHandle = (HANDLE)pInput;

	return 0;
}

int	TsMux::DelStream(HANDLE hStream)
{
	if (!m_pMux)
		return -1;

	if ( ::DelStream( m_pMux, (input_t *)hStream ) != 0)
		return -2;

	return 0;
}

int	TsMux::MuxEsData(HANDLE hStream, PBYTE pEsData, DWORD nEsDataSize,
						INT64 i_length, INT64 i_pts, INT64 i_dts, UINT32 i_flags)
{
	input_t * pInput = NULL;
	for (int i = 0; i < m_pMux->i_nb_inputs; i++)
	{
		pInput = m_pMux->pp_inputs[i];
		if (pInput == (input_t*)hStream)
			break;
	}

	if (!pInput)
		return -1;

	block_t* pEs = (block_t*)pInput->p_fifo->GetEmptyBuffer();
	if (!pEs)
	{
		pEs = new block_t();
		if (!pEs)
			return -2;
	}
	
	if (!pEs->AllocateBuffer(nEsDataSize))
	{
		delete pEs;
		return -3;
	}

	pEs->FillData(pEsData, nEsDataSize);
	
	pEs->i_length = i_length;
	pEs->i_pts = i_pts;
	pEs->i_dts = i_dts;
	pEs->i_flags = i_flags;

	pInput->p_fifo->AddFullBuffer(pEs);

	return ::Mux(m_pMux);
}
