//////////////////////////////////////////////////////////////////////////
// ϲ֮ɵĿ
// 70565912@qq.com
//////////////////////////////////////////////////////////////////////////
#pragma once

#include "common.h"
#include "es.h"

#define HAVE_DVBPSI_SDT
#define HAVE_BSEARCH

typedef struct mux_t mux_t;

struct TsMuxParam_t
{
	int pid_video;
	int pid_audio;
	int pid_spu;
	int pid_pmt;
	int tsid;
	int netid;

	char	*program_pmt;
	BOOL	es_id_pid;
	char	*muxpmt;
	char	*sdtdesc;
	BOOL	alignment;

	int		shaping;
	BOOL	use_key_frames;

	int	pcr;
	int	bmin;
	int bmax;
	int dts_delay;

	BOOL crypt_audio;
	BOOL crypt_video;

	char *csa_ck;
	int	 csa_pkt;
} ;

static void TsMuxParam_defualt(TsMuxParam_t* p_param)
{
	ZeroMemory(p_param, sizeof(TsMuxParam_t));

	p_param->pid_video = 0;
	p_param->pid_audio = 0;
	p_param->pid_spu = 0;
	p_param->pid_pmt = 0;
	p_param->tsid = 0;
	p_param->netid = 0;

	p_param->program_pmt = NULL;
	p_param->es_id_pid = FALSE;
	p_param->muxpmt = NULL;
	p_param->sdtdesc = NULL;
	p_param->alignment = TRUE;

	p_param->shaping = 200;
	p_param->use_key_frames = FALSE;

	p_param->pcr = 70;
	p_param->bmin = 0;
	p_param->bmax = 0;
	p_param->dts_delay = 400;

	p_param->crypt_audio = TRUE;
	p_param->crypt_video = TRUE;

	p_param->csa_ck = NULL;
	p_param->csa_pkt = 188;
};

typedef void (*GetTsDataCBFun) (PVOID pUserData, PBYTE pTsData, DWORD nTsDataSize);

class TsMux
{
public:
	TsMux();

	~TsMux();

	int		Open(TsMuxParam_t* p_param, GetTsDataCBFun pGetTsDataCBFun, PVOID pUserData);

	int		AddStream(HANDLE *pHandle, es_format_t *p_fmt);

	int		DelStream(HANDLE hStream);

	int		MuxEsData(HANDLE hStream, PBYTE pEsData, DWORD nEsDataSize, INT64 i_length, INT64 i_pts, INT64 i_dts, UINT32 i_flags);

	void	Close();

private:
	//static unsigned int WINAPI RunThread(void *pParam);
	//void Thread();

	mux_t* m_pMux;

	HANDLE m_hThread;
	HANDLE m_eThreadStop;
	HANDLE m_eData;
};

