/*****************************************************************************
 * csa.h
 *****************************************************************************
 * Copyright (C) 2004 Laurent Aimar
 * $Id: csa.h 13905 2006-01-12 23:10:04Z dionoea $
 *
 * Authors: Laurent Aimar <fenrir@via.ecp.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

#ifndef _CSA_H
#define _CSA_H 1

#include "common.h"

typedef struct csa_t csa_t;

EXPORT(csa_t *, csa_New,	(void));
EXPORT(void,	csa_Delete, (csa_t *c ));
EXPORT(void,	csa_SetCW,	(csa_t *c, uint8_t o_ck[8], uint8_t e_ck[8]));
EXPORT(void,	csa_Decrypt,(csa_t *c, uint8_t *pkt, int i_pkt_size));
EXPORT(void,	csa_Encrypt,(csa_t *c, uint8_t *pkt, int i_pkt_size, int b_odd));

#endif /* _CSA_H */
