//////////////////////////////////////////////////////////////////////////
// ϲ֮ɵĿ
// 70565912@qq.com
//////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "libTsMux.h"

#include "TsMux.h"

libTsMux::libTsMux()
{
	m_pTsMux = NULL;
}

libTsMux::~libTsMux()
{

}

BOOL libTsMux::Open(const libTsMuxParam_t& param)
{
	if (m_pTsMux)
		return FALSE;

	TsMuxParam_t ts_mux_param;
	TsMuxParam_defualt( &ts_mux_param );

	ts_mux_param.pid_video = param.m_nPidVideo;
	ts_mux_param.pid_audio = param.m_nPidAudio;
	ts_mux_param.pid_pmt = param.m_nPidPmt;
	ts_mux_param.bmin = param.m_nBitrateMin;
	ts_mux_param.bmax = param.m_nBitrateMax;
	ts_mux_param.use_key_frames = param.m_bUseKeyFrames;
	ts_mux_param.shaping = param.m_nShaping;

	m_pTsMux = new TsMux();
	if (!m_pTsMux)
		return FALSE;

	int iError = m_pTsMux->Open(&ts_mux_param, param.m_pGetTsDataCB, param.m_pUserData);
	if (iError)
		return FALSE;

	return TRUE;
}

HANDLE libTsMux::AddStream(es_format_t *p_fmt)
{
	HANDLE h_stream;

	int iError = m_pTsMux->AddStream(&h_stream, p_fmt);
	if (iError)
		return NULL;

	return h_stream;
}

BOOL libTsMux::DelStream(HANDLE hStream)
{
	if (!m_pTsMux)
		return FALSE;

	if (m_pTsMux->DelStream(hStream) != 0)
		return FALSE;
	return TRUE;
}

BOOL libTsMux::Mux(HANDLE hStream, PBYTE p_es_data, DWORD i_es_data_size, INT64 i_length, INT64 i_pts, INT64 i_dts, UINT32 i_flags)
{
	if (m_pTsMux->MuxEsData(hStream, p_es_data, i_es_data_size, i_length, i_pts, i_dts, i_flags) != 0)
		return FALSE;
	return TRUE;
}

BOOL libTsMux::Close()
{
	if (m_pTsMux)
	{
		m_pTsMux->Close();
		delete m_pTsMux;
	}
	m_pTsMux = NULL;
	return TRUE;
}