//////////////////////////////////////////////////////////////////////////
// ϲ֮ɵĿ
// 70565912@qq.com
//////////////////////////////////////////////////////////////////////////
#pragma once

#include "common.h"
#include "es.h"
#include "block.h"

//#if LIBTSMUX_EXPORTS
//#	define LIBTSMUX_API __declspec(dllexport)
//#else
//#	define LIBTSMUX_API __declspec(dllimport)
//#endif
#define LIBTSMUX_API

#define TS_MUX_FLAG_I 0x0002
#define TS_MUX_FLAG_P 0x0004
#define TS_MUX_FLAG_B 0x0008

typedef void (*GetTsDataCB) (PVOID pUserData, PBYTE pTsData, DWORD nTsDataSize);

struct libTsMuxParam_t
{
	INT m_nPidVideo;
	INT m_nPidAudio;
	INT m_nPidPmt;

	INT  m_nBitrateMin;;
	INT  m_nBitrateMax;

	BOOL m_bUseKeyFrames;

	INT	 m_nShaping;

	GetTsDataCB m_pGetTsDataCB;
	VOID*		m_pUserData;

	libTsMuxParam_t()
	{
		m_nPidVideo = 0;
		m_nPidAudio = 0;
		m_nPidPmt = 0;

		m_nBitrateMin = 0;
		m_nBitrateMax = 0;

		m_bUseKeyFrames = FALSE;

		m_nShaping = 200;

		m_pGetTsDataCB = NULL;
		m_pUserData = NULL;
	}
};

class LIBTSMUX_API libTsMux
{
public:
	libTsMux();
	~libTsMux();

	BOOL	Open(const libTsMuxParam_t& param);

	HANDLE	AddStream(es_format_t *p_fmt);

	BOOL	DelStream(HANDLE hStream);

	BOOL	Mux(HANDLE hStream, PBYTE p_es_data, DWORD i_es_data_size, INT64 i_length, INT64 i_pts, INT64 i_dts, UINT32 i_flags);

	BOOL	Close();

private:
	class TsMux * m_pTsMux;
};


